/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "keycapture.h"
#include "independent.h"
#include <apgtask.h> // Going background 
#include <bautils.h>
#include <w32std.h>
#include "screen.h"
#include <viewcli.h> //CVwsSessionWrapper
#include <apgwgnam.h>

enum JOYSTICK_EVENTS {
	JOY_LEFT = 0xF807,
	JOY_RIGHT = 0xF808,
	JOY_UP = 0xF809,
	JOY_DOWN = 0xF80A,
	JOY_CLICK = EKeyDevice3
};

const TUid KUidcontextbook = { 0x101FBAD0 };
const TUid KUidPhone = { 0x100058b3 };
const TUid KUidMenu = {  0x101f4cd2 };

#ifndef __WINS__
_LIT(contextbook_filen, "c:\\system\\apps\\contextbook\\contextbook.app");
#else
_LIT(contextbook_filen, "z:\\system\\apps\\contextbook\\contextbook.app");
#endif

void do_start_keycapture(TAny* aPtr)
{
	worker_info *wi=(worker_info*)aPtr;
	TKeycaptureArgs *args=(TKeycaptureArgs*)wi->worker_args;

	RWsSession ws;
	User::LeaveIfError(ws.Connect());
	CleanupClosePushL(ws);

	TRequestStatus status;

	RWindowGroup wg(ws);
	wg.Construct((TUint32)&wg, EFalse);
	CleanupClosePushL(wg);

	/*
	 * This will mess the key repeat for these keys.
	 * Could be fixed by writing our own key repeat
	 * timer (or on S60v2 by using CaptureLongKey).
	 */

	User::LeaveIfError(wg.CaptureKey(EKeyLeftArrow, 0, 0));
	User::LeaveIfError(wg.CaptureKey(EKeyRightArrow, 0, 0));
	User::LeaveIfError(wg.CaptureKey(JOY_CLICK, 0, 0));
	User::LeaveIfError(wg.CaptureKey(EKeyUpArrow, 0, 0));
	User::LeaveIfError(wg.CaptureKey(EKeyDownArrow, 0, 0)); 
	User::LeaveIfError(wg.CaptureKey(EKeyYes, 0, 0));
	User::LeaveIfError(wg.CaptureKey(EKeyNo, 0, 0));

/*
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_LEFT, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_RIGHT, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_CLICK, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_UP, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(JOY_DOWN, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(EKeyYes, 0, 0));
	User::LeaveIfError(wg.CaptureKeyUpAndDowns(EKeyNo, 0, 0));
*/

	RFs fsSession;
	User::LeaveIfError(fsSession.Connect());
	CleanupClosePushL(fsSession);

	bool book_exists=false;
	// ContextBook activation
	if (BaflUtils::FileExists(fsSession, contextbook_filen)) {
		book_exists=true;
	}

	screen* screenhelp=new (ELeave) screen;
	screenhelp->ConstructL(&ws);
	CleanupStack::PushL(screenhelp);

	CVwsSessionWrapper* vws;
	vws=CVwsSessionWrapper::NewLC();

	ws.EventReady(&status);

	wg.SetOrdinalPosition(-1);
	wg.EnableReceiptOfFocus(EFalse);
	CApaWindowGroupName* wn=CApaWindowGroupName::NewLC(ws);
	wn->SetHidden(ETrue);
	wn->SetWindowGroupName(wg);

	//TRequestStatus parent_thread_status;
	RThread parent;
	parent.Open(wi->parent_threadid);
	/*
		We'd like to actually react to parent thread death
		and try to log it, put once the main thread of a process
		is killed all other threads are too, that means this thread :-)
	*/

	for(;;) {
		User::WaitForAnyRequest();
		
		if ( (*wi->do_stop)!=KRequestPending) {
			break;
		}
		if (status.Int()==KErrNone) {
			TWsEvent e;
			ws.GetEvent(e);

			if (*(args->iKeyStatus)==KRequestPending) {
				TRequestStatus *sp=args->iKeyStatus;
				parent.RequestComplete(sp, KErrNone);
			}
			TInt wgid=ws.GetFocusWindowGroup();

			TInt c;
			TKeyEvent* aKeyEvent=e.Key();
			c=aKeyEvent->iCode;
            
			CApaWindowGroupName* gn;
			gn=CApaWindowGroupName::NewLC(ws, wgid);

			// There's no Phone app on the emulator, so
			// we test it with Menu; on the phone the joystick
			// is used for the menu so we cannot use it
#ifndef __WINS__
			if (gn->AppUid()==KUidPhone && 
				! screenhelp->dialog_on_screen() && book_exists) {
#else
			if (gn->AppUid()==KUidMenu && 
				! screenhelp->dialog_on_screen() && book_exists) {
#endif
				switch(c) {
				case JOY_CLICK:
					vws->ActivateView(TVwsViewId(KUidcontextbook, TUid::Uid(1)),TUid::Null(),KNullDesC8);
					break;
				case EKeyYes:
					vws->ActivateView(TVwsViewId(KUidcontextbook, TUid::Uid(2)),TUid::Null(),KNullDesC8);
					break;
				case JOY_LEFT:
#ifdef __WINS__
	BaflUtils::CopyFile(fsSession, _L("C:\\nokia\\images\\img.jpg"), _L("C:\\nokia\\images\\img2.jpg"));

	break;
#endif
				case JOY_RIGHT:
				default:
					ws.SendEventToWindowGroup(wgid, e);
					break;
				}
			} else {
				// otherwise send event to foreground app
				ws.SendEventToWindowGroup(wgid, e);
				

			}
			CleanupStack::PopAndDestroy();
			ws.EventReady(&status);

		}
		if ( (*wi->do_stop)!=KRequestPending) {
			break;
		}
	}
	ws.EventReadyCancel();
	parent.Close();

	CleanupStack::PopAndDestroy(6); //ws, wg, fsSession, screenhelp, vws, wn
}

TInt start_keycapture(TAny* aPtr)
{

        CTrapCleanup *cl;
        cl=CTrapCleanup::New();

        TInt err=0;
        TRAP(err,
                do_start_keycapture(aPtr));

	delete cl;

	TTimeIntervalMicroSeconds32 w(50*1000);
	User::After(w);
	worker_info* wi=(worker_info*)aPtr;
	wi->stopped();
        return err;
}