/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_appuse.h"
#include "symbian_auto_ptr.h"
#include "apgwgnam.h"
#include <e32std.h>

CLog_AppUse::~CLog_AppUse()
{
	CALLSTACKITEM(_L("CLog_AppUse::~CLog_AppUse"));

	Cancel();
	iTimer.Close();
	delete iValue;
}

const TDesC& CLog_AppUse::get_value()
{
	CALLSTACKITEM(_L("CLog_AppUse::get_value"));

	TInt wgid=Ws().GetFocusWindowGroup();
	auto_ptr<CApaWindowGroupName> gn(CApaWindowGroupName::NewL(Ws(), wgid));
	iUid=gn->AppUid();
	const TDesC& named=iUid.Name();
	const TDesC& captiond=gn->Caption();
	iValue->Des().Format(*log_format, &named, &captiond);
	return *iValue;
}

void CLog_AppUse::CheckedRunL()
{
	CALLSTACKITEM(_L("CLog_AppUse::CheckedRunL"));

	TUid prev=iUid;
	get_value();
#if 1
	if (prev!=iUid) {
		post_new_value(*iValue);
	}
#else
	post_new_value(*iValue);
#endif

	Wait();
}

CLog_AppUse* CLog_AppUse::NewL(MApp_context& Context)
{
	CALLSTACKITEM(_L("CLog_AppUse::NewL"));

	auto_ptr<CLog_AppUse> ret(new (ELeave) CLog_AppUse(Context));
	ret->ConstructL();
	return ret.release();
}

void CLog_AppUse::DoCancel()
{
	CALLSTACKITEM(_L("CLog_AppUse::DoCancel"));

	iTimer.Cancel();
}

void CLog_AppUse::Wait()
{
	CALLSTACKITEM(_L("CLog_AppUse::Wait"));

	if (User::InactivityTime().Int()>iTimeOut) {
		iCurrentState=EIdle;
		iTimer.Inactivity(iStatus, 0);
	} else {
		iTimer.After(iStatus, TTimeIntervalMicroSeconds32(1*1000*1000));
		iCurrentState=EActive;
	}
	SetActive();
}

TInt CLog_AppUse::CheckedRunError(TInt /*aError*/)
{
	CALLSTACKITEM(_L("CLog_AppUse::CheckedRunError"));

	Wait();
	return KErrNone;
}

CLog_AppUse::CLog_AppUse(MApp_context& Context) : CCheckedActive(EPriorityHigh, _L("CLog_AppUse")), 
Mlog_base_impl(Context), iTimeOut(5)
{
	CALLSTACKITEM(_L("CLog_AppUse::CLog_AppUse"));

}

void CLog_AppUse::ConstructL()
{
	CALLSTACKITEM(_L("CLog_AppUse::ConstructL"));

	iValue=HBufC::NewL(40);
	Mlog_base_impl::ConstructL(_L("ActiveApp"), _L("%S %S"));
	iTimer.CreateLocal();
	CActiveScheduler::Add(this);
	Wait();
}
