/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_base_impl.h"

#include <e32std.h>
#include <eikenv.h>

void Mlog_base_impl::ConstructL(const TDesC& name, const TDesC& format)
{
	CALLSTACKITEM(_L("Mlog_base_impl::ConstructL"));

	TFileName fn;
	TFileName f;
	f=name;
	f.Trim();
	for (int i=0; i<f.Length(); i++) {
		TChar c=f[i];
		if (! c.IsAlpha() ) {
			f[i]='_';
		}
	}
	fn.Format(_L("c:\\system\\apps\\context_log\\%S.txt"), &f);
	TInt ret=debug.Replace(Fs(), fn, EFileShareAny | EFileStreamText | EFileWrite);
	User::LeaveIfError(ret);

	log_name=name.AllocL();
	log_format=format.AllocL();
	loggers=new (ELeave) CArrayFixFlat<Mlogger*>(1);
}

Mlog_base_impl::Mlog_base_impl(MApp_context& Context) : MContextBase(Context),
	log_name(0), log_format(0), loggers(0)
{
	CALLSTACKITEM(_L("Mlog_base_impl::Mlog_base_impl"));

}

void Mlog_base_impl::release_sinks()
{
	CALLSTACKITEM(_L("Mlog_base_impl::release_sinks"));

	if (!loggers) return;
	TTime time;
	time.HomeTime();



	for (int i=0; i<loggers->Count(); i++) {
		(*loggers)[i]->unregister_source(get_name(), time);
	}
	loggers->Reset();
}

Mlog_base_impl::~Mlog_base_impl()
{
	CALLSTACKITEM(_L("Mlog_base_impl::~Mlog_base_impl"));

	debug.Close();
	release_sinks();

	delete log_name;
	delete log_format;
	delete loggers;
}

void Mlog_base_impl::add_sinkL(Mlogger* sink)
{
	CALLSTACKITEM(_L("Mlog_base_impl::add_sinkL"));

	TTime time;
	time.HomeTime();


	add_sinkL(sink, time);
}

void Mlog_base_impl::add_sinkL(Mlogger* sink, const TTime& time)
{
	CALLSTACKITEM(_L("Mlog_base_impl::add_sinkL"));

	if (!sink) return;
	loggers->AppendL(sink);
	sink->register_source(log_name->Des(), get_value(), time);
}

const TDesC& Mlog_base_impl::get_name()
{
	CALLSTACKITEM(_L("Mlog_base_impl::get_name"));

	return *log_name;
}

const TDesC& Mlog_base_impl::get_value()
{
	CALLSTACKITEM(_L("Mlog_base_impl::get_value"));

	return *log_format;
}

void Mlog_base_impl::post_new_value(const TDesC& value, Mlogger::log_priority priority)
{
	CALLSTACKITEM(_L("Mlog_base_impl::post_new_value"));

	TTime time;
	time.HomeTime();


	post_new_value(value, time, priority);
}

void Mlog_base_impl::post_new_value(const TDesC& value, const TTime& time, Mlogger::log_priority priority)
{
	CALLSTACKITEM(_L("Mlog_base_impl::post_new_value"));

	TBuf8<256> name;
	TInt seekpos=0;
	for (int i=0; i<loggers->Count(); i++) {
		Mlogger* l=(*loggers)[i];
		if (l) {
			debug.Seek(ESeekStart, seekpos);
			// NOTE: works only with ASCII chars
			name.Append(l->name());
			debug.Write(name);
			debug.Flush();
			l->new_value(priority, get_name(), value, time);
		}
		debug.Seek(ESeekStart, seekpos);
		debug.Write(_L8("NONE"));
		debug.Flush();
	}
}

Clog_base_impl::Clog_base_impl(MApp_context& Context) : Mlog_base_impl(Context)
{
	CALLSTACKITEM(_L("Clog_base_impl::Clog_base_impl"));

}


Clog_base_impl* Clog_base_impl::NewL(MApp_context& Context, const TDesC& name, const TDesC& format)
{
	CALLSTACKITEM(_L("Clog_base_impl::NewL"));

	Clog_base_impl* ret=new (ELeave) Clog_base_impl(Context);
	CleanupStack::PushL(ret);
	ret->ConstructL(name, format);
	CleanupStack::Pop();
	return ret;
}
