/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_cellid.h"
#include "ver.h"

Clog_cellid::Clog_cellid(MApp_context& Context, CCellMap& CellMap) : CCheckedActive(EPriorityIdle, _L("Clog_cellid")), Mlog_base_impl(Context), cellid_value(0)
{
	CALLSTACKITEM(_L("Clog_cellid::Clog_cellid"));

#ifdef __WINS__
	test_data_i=0;
#endif
}

void Clog_cellid::ConstructL() 
{
	CALLSTACKITEM(_L("Clog_cellid::ConstructL"));

	cellid_value=HBufC::NewL(60);
	Mlog_base_impl::ConstructL(KLog_cellid, _L("%d, %d, %S"));

	CActiveScheduler::Add(this); // add to scheduler
#ifndef __WINS__

        RPhone::TLineInfo lineinfo;
        Phone().GetLineInfo(0, lineinfo);
        line.Open(Phone(), lineinfo.iName);

#ifndef __S60V2__
	Phone().NotifyChangeOfCurrentNetwork(iStatus, async_info);
#else
	Phone().NotifyChangeOfCurrentNetworkNS(iStatus, async_info);
#endif
	SetActive();
#else
	timer.CreateLocal();
	TTimeIntervalMicroSeconds32 w(5*1000*1000);
	timer.After(iStatus, w);
	SetActive();
#endif
}

Clog_cellid* Clog_cellid::NewL(MApp_context& Context, CCellMap& CellMap)
{
	CALLSTACKITEM(_L("Clog_cellid::NewL"));

	Clog_cellid* ret=new (ELeave) Clog_cellid(Context, CellMap);
	CleanupStack::PushL(ret);
	ret->ConstructL();
	CleanupStack::Pop();
	return ret;
}

bool Clog_cellid::call_in_progress()
{
	CALLSTACKITEM(_L("Clog_cellid::call_in_progress"));

	RLine::TLineInfo lineinfo;
	#ifndef __WINS__
		line.GetInfo(lineinfo);
	#else
		lineinfo.iStatus=RCall::EStatusIdle;
	#endif

	if (! (lineinfo.iStatus==RCall::EStatusIdle || lineinfo.iStatus==RCall::EStatusUnknown)) {
		return true;
	}
	return false;
}

Clog_cellid::~Clog_cellid()
{
	CALLSTACKITEM(_L("Clog_cellid::~Clog_cellid"));

	Cancel();

	if (cellid_value) delete cellid_value;

#ifndef __WINS__
	line.Close();
#else
	timer.Close();
#endif
}

void Clog_cellid::DoCancel()
{
	CALLSTACKITEM(_L("Clog_cellid::DoCancel"));

#ifndef __WINS__
#ifndef __S60V2__
	Phone().NotifyChangeOfCurrentNetworkCancel();
#else
	// The Cancel hangs on v2 :-(
	//Phone().NotifyChangeOfCurrentNetworkCancelNS();
	TRequestStatus* s=&iStatus;
	User::RequestComplete(s, KErrCancel);
#endif
#else
	timer.Cancel();
#endif
}

TInt Clog_cellid::CheckedRunError(TInt aError)
{
	CALLSTACKITEM(_L("Clog_cellid::CheckedRunError"));
	if (iErrorCount >= 10) return aError;

	TBuf<20> msg;
	msg.Format(_L("ERROR %d"), aError);
	post_new_value(_L("RunError"), Mlogger::VALUE);

#ifndef __WINS__
	Cancel();
#  ifndef __S60V2__
	Phone().NotifyChangeOfCurrentNetwork(iStatus, async_info);
#  else
	Phone().NotifyChangeOfCurrentNetworkNS(iStatus, async_info);
#  endif
	SetActive();
	return KErrNone;
#else // __WINS__
	return aError;
#endif
}

void Clog_cellid::CheckedRunL()
{
	CALLSTACKITEM(_L("Clog_cellid::CheckedRunL"));

	if (iStatus!=KErrNone) {
		TBuf<20> msg;
		msg.Format(_L("ERROR %d"), iStatus.Int());
		post_new_value(msg, Mlogger::VALUE);
		if (iErrorCount++ >= 10) {
			User::Leave(-1005);
		}
	} else {
		iErrorCount=0;
#ifndef __WINS__
		cellid_value->Des().Format(*log_format, async_info.iLocationAreaCode, async_info.iCellId,
			&(async_info.iNetworkInfo.iShortName));
		post_new_value(cellid_value->Des());
		
		prev_info=async_info;
	}
#  ifndef __S60V2__
	Phone().NotifyChangeOfCurrentNetwork(iStatus, async_info);
#  else
	Phone().NotifyChangeOfCurrentNetworkNS(iStatus, async_info);
#  endif
	SetActive();
#else
		cellid_value->Des()=bases::test_data[test_data_i++][1];
		while (! cellid_value->Des().Compare(_L("SWITCH"))) {
			cellid_value->Des()=bases::test_data[test_data_i++][1];
		}
		post_new_value(cellid_value->Des());
	}
	TTimeIntervalMicroSeconds32 w(20*1000*1000);
	timer.After(iStatus, w);
	SetActive();
	//iErrorCount=10; User::Leave(1);
	//User::Panic(_L("test panic"), 10);
	//RThread me;
	//me.Open(me.Id());
	//me.RaiseException(EExcAccessViolation);
#endif

}

const TDesC& Clog_cellid::get_value()
{
	CALLSTACKITEM(_L("Clog_cellid::get_value"));

	MBasicGsmPhoneNetwork::TCurrentNetworkInfo ni;
	ni.iLocationAreaCode=ni.iCellId=0;
	// get network info

#ifndef __WINS__
	User::LeaveIfError( Phone().GetCurrentNetworkInfo( ni ) );
	prev_info=ni;
#else
	ni.iNetworkInfo.iShortName=_L("RADIOLINJA");
#endif

	cellid_value->Des().Format(*log_format, ni.iLocationAreaCode, ni.iCellId,
		&(ni.iNetworkInfo.iShortName));

	return *cellid_value;
}
