/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CONTEXTBOOKCONTAINER_H
#define CONTEXTBOOKCONTAINER_H

// INCLUDES
#include <coecntrl.h>
#include <aknlists.h>
#include <cntitem.h>
#include <e32base.h>
#include <CPbkContactEngine.h>
#include <eikedwin.h>
#include <sendui.h>
#include <aknglobalnote.h>
#include <cpbkcontactengine.h> 
#include <akniconarray.h>

#include "phonehelper.h"
#include "phonebook.h"

#include "file_output_base.h"
#include "icons.h"

// FORWARD DECLARATIONS
class CEikLabel;        // for example labels

class CContextbookContainer : public CCoeControl, MCoeControlObserver, MEikListBoxObserver, MEikEdwinObserver, public phonebook_observer
{
public: // Constructors and destructor
        
        /**
        * EPOC default constructor.
        * @param aRect Frame rectangle for container.
        */
        void ConstructL(const TRect& aRect, phonebook_i* i_book, bool i_searchable, const TDesC& title, Cfile_output_base * aLog, CAknIconArray * aIconlist, TInt current_item_index, TInt top_item_index,  TBuf<20> current_filter);
		
        /**
        * Destructor.
        */
        ~CContextbookContainer();
	
public: // New functions
	void call_current();
	void sms_current();
	void show_presence_details_current();
	TInt get_current_idx();
	TInt get_top_idx();
	void GetCurrentFilter(TDes& aBuffer);
	void ResetSearchField();
	void filter();
public: // Functions from base classes

	// phonebook_observer
	void contents_changed();	
	void before_change();

	void exiting();
private: // Functions from base classes
	
	 /**
	 * From CoeControl,SizeChanged.
        */
        void SizeChanged();
	
	/**
        * From CoeControl,CountComponentControls.
        */
        TInt CountComponentControls() const;
	
	/**
        * From CCoeControl,ComponentControl.
        */
        CCoeControl* ComponentControl(TInt aIndex) const;
	
	/**
        * From CCoeControl,Draw.
        */
        void Draw(const TRect& aRect) const;
	
	/**
        * From ?base_class ?member_description
        */
        // event handling section
        // e.g Listbox events
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
	
        void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);
	
        TKeyResponse OfferKeyEventL(const TKeyEvent &, TEventCode);
	
	void HandleEdwinEventL(CEikEdwin* aEdwin,TEdwinEvent aEventType);

	virtual bool is_searchable() const; // whether to include the search box
	
	

private: //data
        
    CEikFormattedCellListBox* listbox;
	CEikEdwin * edit;
	CArrayFixFlat<TInt>* resource_files;
	phonehelper* phone;
	phonebook_i* book;
	CSendAppUi* sendui;
	CAknGlobalNote* globalNote;
	CPbkContactEngine* pbkengine;
	bool owns_engine;
	bool searchable;

	TInt	iCurrentContactId;

	Cfile_output_base * iLog;
	CAknIconArray * iconlist;
};

#endif

// End of File
