/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/

#ifndef CONTEXTBOOKVIEW_H
#define CONTEXTBOOKVIEW_H

// INCLUDES
#include <aknview.h>
#include "phonebook.h"
#include "jabberdata.h"
#include "file_output_base.h"
#include <akniconarray.h> 

// CONSTANTS
// UID of view
const TUid KViewId = {1};
const TUid KView2Id = {2};

// FORWARD DECLARATIONS
class CContextbookContainer;

// CLASS DECLARATION

/**
*  CContextbookView view class.
* 
*/
class CContextbookView : public CAknView
    {
    public: // Constructors and destructor

	    CContextbookView(CJabberData& JabberData, Cfile_output_base * aLog) : iJabberData(JabberData), iLog(aLog), exiting (false) { }
        void ConstructL(TUid i_id, phonebook_i* i_book, bool i_searchable, const TDesC& i_title, CAknIconArray * aIconlist);

	TInt GetCurrentIdx();
        /**
        * Destructor.
        */
        ~CContextbookView();

	
    public: // Functions from base classes
        
        /**
        * From ?base_class ?member_description
        */
        TUid Id() const;

        /**
        * From ?base_class ?member_description
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From ?base_class ?member_description
        */
        void HandleClientRectChange();

		void ResetSearchField();

		void before_exit();



    private:

        /**
        * From AknView, ?member_description
        */
        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId,
            const TDesC8& aCustomMessage);

        /**
        * From AknView, ?member_description
        */
        void DoDeactivate();

	virtual CContextbookContainer* create_container();
	void set_nick();
	void ShowEditor();

    private: // Data
        CContextbookContainer* iContainer;
	TUid id;
	phonebook_i* book;
	bool searchable;
	bool exiting;
	TBuf<50> title;
	CJabberData& iJabberData;

	TInt current_item_index;
	TInt top_item_index;
	TBuf<20> current_edit_filter;


	Cfile_output_base * iLog;

	CAknIconArray * iconlist;

	};

#endif

// End of File
