/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/*
* ============================================================================
*  Name     : CContextbookDocument from ContextbookDocument.h
*  Part of  : contextbook
*  Created  : 14.7.2003 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

// INCLUDE FILES
#include "ContextbookDocument.h"
#include "ContextbookAppUi.h"
#include "settings.h"

// ================= MEMBER FUNCTIONS =======================

// constructor
CContextbookDocument::CContextbookDocument(CEikApplication& aApp)
: CAknDocument(aApp)    
    {
    }

// destructor
CContextbookDocument::~CContextbookDocument()
    {
	iContext->Release();
    }

// EPOC default constructor can leave.
void CContextbookDocument::ConstructL()
    {
	iContext=CApp_context::NewL();

#ifndef __WINS__
	TParsePtrC parse(Application()->DllName());
	iContext->SetAppDir(parse.DriveAndPath());
#else
	iContext->SetAppDir(_L("c:\\system\\apps\\contextbook\\"));
#endif
	iContext->SetDataDir(_L("c:\\system\\data\\context\\"));
	iContext->AddRef();
	CSettings* s=CSettings::NewL(*iContext, iNoDefaults, true, _L(""), true); // readonly settings
	iContext->SetSettings(s);
    }

// Two-phased constructor.
CContextbookDocument* CContextbookDocument::NewL(
        CEikApplication& aApp)     // CContextbookApp reference
    {
    CContextbookDocument* self = new (ELeave) CContextbookDocument( aApp );
    CleanupStack::PushL( self );
    self->ConstructL();
    CleanupStack::Pop();

    return self;
    }
    
// ----------------------------------------------------
// CContextbookDocument::CreateAppUiL()
// constructs CContextbookAppUi
// ----------------------------------------------------
//
CEikAppUi* CContextbookDocument::CreateAppUiL()
    {
    return new (ELeave) CContextbookAppUi(*iContext);
    }

// End of File  
