/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include <e32base.h>
#include <e32cons.h>
#include <stdlib.h>
#include <apgcli.h>
#include <apgtask.h>
#include <w32std.h>

const TUid KUidcontext_log = { 0x05CCC0AF };
const TUid KUidPhone = { 0x100058b3 };
const TUid KUidMenu = {  0x101f4cd2 };

const TInt KUidCloseLogValue=0x2003;
const TUid KUidCloseLog={KUidCloseLogValue};

// This is the mainloop game loop or whatever
void mainloop(void)
{

	CConsoleBase* console=0;
	//console=Console::NewL(_L("starter"),TSize(KConsFullScreen,KConsFullScreen));
	//CleanupStack::PushL(console);

	RTimer timer; // The asynchronous timer and ...
	timer.CreateLocal(); // Always created for this thread.
	CleanupClosePushL(timer);

	TTime time;

	RApaLsSession ls;
	User::LeaveIfError(ls.Connect());
	CleanupClosePushL(ls);

	RWsSession ws;
	User::LeaveIfError(ws.Connect());
	CleanupClosePushL(ws);

	TRequestStatus context_log_status, timer_status;
	TApaTaskList tl(ws);

	// don't start app until phone has actually booted up
#ifndef __WINS__
		while (! tl.FindApp(KUidPhone).Exists()) {
#else
		while (! tl.FindApp(KUidMenu).Exists()) {
#endif
		time.HomeTime();
		time+=TTimeIntervalSeconds(60);
		timer.At(timer_status,time);
		User::WaitForRequest(timer_status);
	}


	_LIT(filen, ""); //dummy

	TThreadId context_log_threadid;

	TApaTask context_log_task=tl.FindApp(KUidcontext_log);
	if (! context_log_task.Exists() ) {
		User::LeaveIfError( ls.StartDocument(filen, KUidcontext_log, context_log_threadid) );

		if (console) console->Printf(_L("after startDocument"));
	} else {
		if (console) console->Printf(_L("exists already"));
		context_log_threadid=context_log_task.ThreadId();
	}

	//wake up on thread death
	RThread context_log_thread;
	bool thread_is_open;
	User::LeaveIfError(context_log_thread.Open(context_log_threadid)); thread_is_open=true;
	context_log_thread.Logon(context_log_status);
	bool logged_on=true;

#ifndef __WINS__
	TTimeIntervalHours wait_interval(1);
	//TTimeIntervalMinutes wait_interval(1);
	TInt restart_on_count=23;
	//TInt restart_on_count=2;
#else
	TTimeIntervalSeconds wait_interval(5);
	TInt restart_on_count=23;
#endif

	int wait_count=0; // we can only wait upto 1 hour at a time,
			// so count to 24...

	time.HomeTime();
	time += wait_interval;
	if (console) {
		TBuf<30> dt;
		time.FormatL(dt, _L("%F%Y-%M-%D %H:%T:%S\n"));
		console->Printf(dt);
	}

	timer.At(timer_status,time);

	bool done=false; bool restarting=false; bool doing_restart=false;
	int restart_count=0; const int RESTART_MAX=20;

	while(!done) {
		User::WaitForRequest(timer_status, context_log_status);
		if (timer_status!=KRequestPending && !doing_restart) {
			RDebug::Print(_L("timer!"));
			if (console) {
				TBuf<30> dt;
				time.FormatL(dt, _L("%F%Y-%M-%D %H:%T:%S\n"));
				console->Printf(_L("%d "), timer_status);
				console->Printf(dt);
			}
			if (wait_count==restart_on_count) {
				TApaTask context_log_task=tl.FindApp(KUidcontext_log);
				if (!context_log_task.Exists()) {
					restarting=true;
					doing_restart=true;
				} else {
					context_log_task.SendSystemEvent(EApaSystemEventShutdown);
					//context_log_task.SendMessage(KUidCloseLog, _L8(""));

					if (console) console->Printf(_L("shut context_log\n"));
				}
				restarting=true; restart_count=0;
				wait_count=0;
			} else {
				wait_count++;
			}
			time.HomeTime();
			time += wait_interval;
			timer.At(timer_status, time);
		} 
		if (context_log_status!=KRequestPending || doing_restart) {
			if (console) console->Printf(_L("context_log stopped\n"));
			TInt etype=0, ereason=0;
			TExitCategoryName ecat=0;
			if (context_log_status!=KRequestPending) {
				logged_on=false;
				etype=context_log_thread.ExitType();
				ereason=context_log_thread.ExitReason();
				ecat=context_log_thread.ExitCategory();
				context_log_thread.Close(); thread_is_open=false;
			}
			
			if ((etype!=0 || (etype==0 && ereason==2003) || restarting) && restart_count<RESTART_MAX) {
				time.HomeTime();
				time+=TTimeIntervalSeconds(30);
				timer.Cancel();
				timer.At(timer_status, time);
				User::WaitForRequest(timer_status);

				TInt err;
				err=ls.StartDocument(filen, KUidcontext_log, context_log_threadid);
				restart_count++;
				if (err==KErrNone) {
					if (thread_is_open) {
						context_log_thread.Close();
						thread_is_open=false;
					}
					User::LeaveIfError(context_log_thread.Open(context_log_threadid));
					thread_is_open=true;
					context_log_thread.Logon(context_log_status);
					logged_on=true;
					restarting=false;
					doing_restart=false;

					time.HomeTime();
					time+=wait_interval;
					timer.At(timer_status, time);
				} else {
					if (console) {
						TBuf<30> msg;
						msg.Format(_L("Error starting %d\n"), err);
						console->Printf(msg);
					}
					doing_restart=true;
					time.HomeTime();
					time+=TTimeIntervalSeconds(30);
					timer.Cancel();
					timer.At(timer_status, time);
					restarting=true;
				}
			} else {
				// user shutdown
				done=true;
			}
		}
	}
	if (logged_on) context_log_thread.LogonCancel(context_log_status);
	if (thread_is_open) context_log_thread.Close();
	if (console) {
		console->Getch(); // get and ignore character
		CleanupStack::PopAndDestroy(4); //console, ws, ls, timer
	} else {
		CleanupStack::PopAndDestroy(3); // ws, ls, timer
	}

}

_LIT(KTxtEPOC32EX,"Whoops!");

#ifdef __WINS__

EXPORT_C TInt InitEmulator() // mainloop function called by the emulator software
{
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error,mainloop()); // more initialization, then do example
	__ASSERT_ALWAYS(!error,User::Panic(KTxtEPOC32EX,error));
	delete cleanup; // destroy clean-up stack
	__UHEAP_MARKEND;
	
	//CloseSTDLIB();
	User::Exit(0);
	
	return KErrNone;
}

int GLDEF_C E32Dll(TDllReason)
{
	return(KErrNone);
}

#else

GLDEF_C TInt E32Main() // mainloop function called by E32
{
	__UHEAP_MARK;
	CTrapCleanup* cleanup=CTrapCleanup::New(); // get clean-up stack
	TRAPD(error,mainloop()); // more initialization, then do example
	__ASSERT_ALWAYS(!error,User::Panic(KTxtEPOC32EX,error));
	delete cleanup; // destroy clean-up stack
	__UHEAP_MARKEND;
	
	//CloseSTDLIB();
	User::Exit(0);
	
	return KErrNone; // and return
}

#endif

