/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(APP_CONTEXT_H_INCLUDED)

#define APP_CONTEXT_H_INCLUDED 1

#include <f32file.h>
#include <charconv.h>
#include <e32std.h>
#include <etel.h>
#include <etelbgsm.h>

#ifndef NO_ETELAGSM_H
#include <etelagsm.h>
typedef RAdvGsmPhone RPhoneType;
#else
typedef RBasicGsmPhone RPhoneType;
#endif

#include <saclient.h>
#include <aknglobalnote.h> 
#include <w32std.h>
#include "checkedactive.h"
#include "list.h"

#define DESTROY(x) { delete x; x=0; }


IMPORT_C void exceptionhandler(TExcType);

class MSettingListener {
public:
	virtual void SettingChanged(TInt Setting) = 0;
};

class MSettings {
public:
	virtual bool GetSettingL(TInt Setting, TDes& Value)= 0;
	virtual bool GetSettingL(TInt Setting, TDes8& Value)= 0;
	virtual bool GetSettingL(TInt Setting, TInt& Value)= 0;
	virtual bool GetSettingL(TInt Setting, TTime& Value)= 0;
	// virtual bool GetSettingL(TInt Setting, TBool& Value)= 0; TBool is typedeffed to int
	virtual void WriteSettingL(TInt Setting, const TDesC& Value)= 0;
	virtual void WriteSettingL(TInt Setting, const TDesC8& Value)= 0;
	virtual void WriteSettingL(TInt Setting, const TInt& Value)= 0;
	virtual void WriteSettingL(TInt Setting, const TTime& Value)= 0;
	// virtual void WriteSettingL(TInt Setting, const TBool& Value)= 0; TBool is typedeffed to int
	virtual ~MSettings() { }
	virtual void NotifyOnChange(TInt Setting, MSettingListener* Listener) = 0;
	virtual void CancelNotifyOnChange(TInt Setting, MSettingListener* Listener) = 0;
};

class MPausable {
public:
	virtual void pause() = 0;
	virtual void unpause() = 0;
	virtual bool is_paused() = 0;
};

class MActiveErrorReporter {
public:
	virtual void ReportError(const TDesC& Source,
		const TDesC& Reason, TInt Code) = 0;
};

class MCallStackVisitor {
public:
	virtual void BeginStack() = 0;
	virtual void VisitItem(const TDesC& Name) = 0;
	virtual void EndStack() = 0;
};

class MApp_context_access {
public:
	virtual RFs&	Fs() = 0;
	virtual RSystemAgent&	SysAgent() = 0;
	virtual RTelServer&	TelServer() = 0;
	virtual RPhoneType&	Phone() = 0;
	virtual CCnvCharacterSetConverter* CC() = 0;
	virtual bool NoSpaceLeft() = 0;
	virtual const TDesC& DataDir() = 0;
	virtual const TDesC& AppDir() = 0;
	virtual MSettings& Settings() = 0;
	virtual RWsSession& Ws() = 0;
	virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code) = 0;
};

class MApp_context: public MApp_context_access {
public:
	virtual ~MApp_context();
	virtual RFs&	Fs() = 0;
	virtual RSystemAgent&	SysAgent() = 0;
	virtual RTelServer&	TelServer() = 0;
	virtual RPhoneType&	Phone() = 0;
	virtual CCnvCharacterSetConverter* CC() = 0;
	virtual bool NoSpaceLeft() = 0;
	virtual void SetFileLog(MPausable* log) = 0;
	virtual void SetActiveErrorReporter(MActiveErrorReporter* Reporter) = 0;
	virtual void SetDataDir(const TDesC& Dir, bool UseMMC) = 0;
	virtual const TDesC& DataDir() = 0;
	virtual const TDesC& AppDir() = 0;
	virtual MSettings& Settings() = 0;
	virtual RWsSession& Ws() = 0;
	virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code) = 0;
	IMPORT_C static MApp_context* Static();
	virtual const char* CallStack() = 0;
	virtual TInt PushCallStack(const TDesC& Name) = 0;
	virtual TPtr PopCallStack() = 0;
	virtual void ResetCallStack() = 0;
	virtual HBufC* GetFormattedCallStack(const TDesC& Prefix) = 0;
	virtual void IterateStack(MCallStackVisitor& aVisitor, const char* aStack=0) = 0;
private:
	int		refcount;
};

class MDiskSpace {
public:
	virtual void DiskSpaceThreshold(TInt aDrive) = 0;
};

class CDiskSpaceNotifier;

class CApp_context : public MApp_context, public CBase {
public:
	IMPORT_C static CApp_context* NewL(bool aFsOnly=false, const TDesC& Name=KNullDesC);
	virtual ~CApp_context();
	virtual void SetActiveErrorReporter(MActiveErrorReporter* Reporter) = 0;
	virtual void SetSettings(MSettings* Settings) = 0;  // takes ownership
	virtual void SetDataDir(const TDesC& Dir, bool UseMMC) = 0;
	virtual void SetAppDir(const TDesC& Dir) = 0;
};

class MContextBase : public MApp_context_access {
public:
	IMPORT_C MContextBase();
	IMPORT_C MContextBase(MApp_context& Context);
	IMPORT_C virtual ~MContextBase();
	IMPORT_C MApp_context&	AppContext();
	IMPORT_C virtual RFs&	Fs();
	IMPORT_C virtual RSystemAgent&	SysAgent();
	IMPORT_C virtual RTelServer&	TelServer();
	IMPORT_C virtual RPhoneType&	Phone();
	IMPORT_C virtual CCnvCharacterSetConverter* CC();
	IMPORT_C virtual bool NoSpaceLeft();
	IMPORT_C virtual const TDesC& DataDir();
	IMPORT_C virtual const TDesC& AppDir();
	IMPORT_C virtual MSettings& Settings(); 
	IMPORT_C virtual RWsSession& Ws();
	IMPORT_C virtual void ReportActiveError(const TDesC& Source,
		const TDesC& Reason, TInt Code);
protected:
	EXPORT_C MApp_context*	GetContext() const;
	MApp_context&	iContext;
};

class TCallStackItem {
public:
	IMPORT_C TCallStackItem(const TDesC& Name, MApp_context* Context);
	IMPORT_C ~TCallStackItem();
private:
	MApp_context* iAppContext;
};

IMPORT_C void MoveIntoDataDirL(MApp_context_access& Context, const TDesC& FileName);

IMPORT_C MApp_context* GetContext();

#define CALLSTACKITEM(X)	TCallStackItem __item(X, GetContext());
#define CALLSTACKITEMSTATIC(X)	TCallStackItem __item(X, CApp_context::Static());
#define CALLSTACKITEM2(X, Y)	TCallStackItem __item(X, Y);

#endif
