/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef DB_H_INCLUDED
#define DB_H_INCLUDED 1

#include <d32dbms.h>
#include <f32file.h>
#include <s32file.h>
#include "app_context.h"

class CDb : public MContextBase, public CBase {
public:
	IMPORT_C static CDb* NewL(MApp_context& Context, const TDesC& dbname, TInt aFileMode, bool shared=false);
	IMPORT_C virtual ~CDb();
	IMPORT_C RDbDatabase& Db();
private:
	CDb(MApp_context& Context, bool shared=false);
	void ConstructL(const TDesC& dbname, TInt aFileMode);
	CPermanentFileStore*	iStore;
	RDbStoreDatabase 	iDb;
	//RDbNamedDatabase 	iDb;
	bool			iDbOpen;
	bool			iShared;
};

class MDBStore {
protected:
	IMPORT_C MDBStore(RDbDatabase& Db);
	IMPORT_C virtual ~MDBStore();
	IMPORT_C void ConstructL(int* columns, int* idx_columns, bool unique_idx,
		const TDesC& name);
	RDbDatabase&	iDb;
	RDbTable		iTable;
	IMPORT_C void SwitchIndexL(TInt Idx); // from 0
	IMPORT_C TInt GetCurrentIndex();
	IMPORT_C void PutL();
	IMPORT_C void SetTextLen(TInt Len);
private:
	int			iCurrentIdx;
	int			iUpdateCount; // for compacting
	int			iTextLen;
	bool			iTableOpen;
};

class CSingleColDbBase  : public MDBStore, public MContextBase, public CBase {
protected:
	CSingleColDbBase(MApp_context& Context, RDbDatabase& Db);
	~CSingleColDbBase();
	bool	SeekL(TInt Idx, bool Updatable=false, bool Add=false);
	void ConstructL(const TDesC& TableName,
		int ColType);
};

template <typename T, typename TMod=T> class CSingleColDb : public CSingleColDbBase {
public:
	static CSingleColDb<T, TMod>* NewL(MApp_context& Context, RDbDatabase& Db, 
		const TDesC& TableName);
	~CSingleColDb();
	bool GetValueL(TInt Idx, TMod& Value);
	void SetValueL(TInt Idx, const T& Value);
	int  ColType() const;
private:
	CSingleColDb(MApp_context& Context, RDbDatabase& Db);
	void ConstructL(const TDesC& TableName);
	void ReadValueL(TMod& Value);
	void WriteValue(const T& Value);
};

#endif
