#include "icons.h"

#include <eikenv.h> 
#include <avkon.mbg>
#include <contextcommon.mbg>
#include <bautils.h>

#define MIN(x,y) (x<y?x:y)
#define _INIT_LITC(txt,maxlen) { MIN(sizeof(txt)-1,maxlen), L##txt}
#define _INIT_T_ICON_ID(txt,val1,val2) { _INIT_LITC(txt,KMaxTextLen), val1, val2}

const TInt KNbIcons=41;

_LIT(KMbmAvkon, "Z:\\system\\data\\avkon.mbm");
#ifndef __WINS__
_LIT(KMbmBook,  "Z:\\system\\data\\contextcommon.mbm");
#else
_LIT(KMbmBook,  "C:\\system\\data\\contextcommon.mbm");
#endif

static const TIconID iconId[KNbIcons]=
{
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_stat_bt_blank, EMbmAvkonQgn_stat_bt_blank +1),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_address, EMbmAvkonQgn_prop_nrtyp_address_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_email, EMbmAvkonQgn_prop_nrtyp_email_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_fax, EMbmAvkonQgn_prop_nrtyp_fax_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_home, EMbmAvkonQgn_prop_nrtyp_home_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_mobile, EMbmAvkonQgn_prop_nrtyp_mobile_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_note, EMbmAvkonQgn_prop_nrtyp_note_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_pager, EMbmAvkonQgn_prop_nrtyp_pager_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_phone, EMbmAvkonQgn_prop_nrtyp_phone_mask ),

/*10*/  _INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_url, EMbmAvkonQgn_prop_nrtyp_url_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_prop_nrtyp_work, EMbmAvkonQgn_prop_nrtyp_work_mask ),
	
	#ifndef __WINS__

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on, EMbmContextcommonSpeaker_on_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on_grey, EMbmContextcommonSpeaker_on_grey_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off, EMbmContextcommonSpeaker_off_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off_grey, EMbmContextcommonSpeaker_off_grey_mask ),
	
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on, EMbmContextcommonVibrator_on_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on_grey, EMbmContextcommonVibrator_on_grey_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off, EMbmContextcommonVibrator_off_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off_grey, EMbmContextcommonVibrator_off_grey_mask ),

/*20*/	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_active, EMbmContextcommonUser_active_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_1, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_2, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_3, EMbmContextcommonUser_inactive_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy1, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy2, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy3, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy4, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy1_grey, EMbmContextcommonBuddy1_mask ),
/*30*/	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy2_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy3_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy4_grey, EMbmContextcommonBuddy1_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther1, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther2, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther3, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther4, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther1_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther2_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther3_grey, EMbmContextcommonBuddy1_mask ),
/*40*/	_INIT_T_ICON_ID("C:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther4_grey, EMbmContextcommonBuddy1_mask ),

	#else

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on, EMbmContextcommonSpeaker_on_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_on_grey, EMbmContextcommonSpeaker_on_grey_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off, EMbmContextcommonSpeaker_off_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonSpeaker_off_grey, EMbmContextcommonSpeaker_off_grey_mask ),
	
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on, EMbmContextcommonVibrator_on_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_on_grey, EMbmContextcommonVibrator_on_grey_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off, EMbmContextcommonVibrator_off_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonVibrator_off_grey, EMbmContextcommonVibrator_off_grey_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_active, EMbmContextcommonUser_active_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_1, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_2, EMbmContextcommonUser_inactive_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonUser_inactive_lvl_3, EMbmContextcommonUser_inactive_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy1, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy2, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy3, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy4, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy1_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy2_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy3_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonBuddy4_grey, EMbmContextcommonBuddy1_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther1, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther2, EMbmContextcommonBuddy2_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther3, EMbmContextcommonBuddy3_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther4, EMbmContextcommonBuddy4_mask ),

	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther1_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther2_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther3_grey, EMbmContextcommonBuddy1_mask ),
	_INIT_T_ICON_ID("Z:\\system\\data\\contextcommon.mbm", EMbmContextcommonOther4_grey, EMbmContextcommonBuddy1_mask ),

	#endif

	_INIT_T_ICON_ID("Z:\\system\\data\\avkon.mbm", EMbmAvkonQgn_indi_marked_add, EMbmAvkonQgn_indi_marked_add_mask)
};

EXPORT_C TInt GetIconBitmap(TInt index)
{
	return iconId[index].iBitmap;
}

EXPORT_C TInt GetIconMask(TInt index)
{
	return iconId[index].iMask;
}


EXPORT_C const TDesC& GetIconMbm(TInt index)
{
	return iconId[index].iMbmFile;
}

EXPORT_C void LoadIcons(CAknIconArray * aIconList)
{
	TFileName real; TFileName prev;
	CEikonEnv* env=CEikonEnv::Static();
	RFs& fs=env->FsSession();
	for (int i = 0; i<KNbIcons;i++)
	{
		if (prev.Compare(iconId[i].iMbmFile)) {
			real=iconId[i].iMbmFile;
			if (! BaflUtils::FileExists(fs, real)) {
				real.Replace(0, 1, _L("e"));
			}
			prev=iconId[i].iMbmFile;
		}
		aIconList->AppendL(env->CreateIconL( real, iconId[i].iBitmap, iconId[i].iMask));
	}
}

EXPORT_C TInt GetIconIndex(TInt identifier)
{
	for (int i = 0; i<KNbIcons;i++)
	{
		if ( iconId[i].iBitmap == identifier )
		{
			return i;
		}
	}	
	return 0; // index of empty icon
}