/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "timeout.h"
#include "symbian_auto_ptr.h"
#include "app_context.h"

class CTimeOutImpl : public CTimeOut {
public:
	~CTimeOutImpl();
private:
	virtual void Wait(int seconds);
	virtual void Reset();

	CTimeOutImpl(MTimeOut& i_cb);
	void ConstructL();
	void RunL();

	MTimeOut& cb;
	TTime	iWaitUntil;
	MApp_context* iContext;

	friend class CTimeOut;
};

CTimeOut::CTimeOut() : CTimer(EPriorityNormal)
{
}

CTimeOut::~CTimeOut()
{
}

CTimeOutImpl::CTimeOutImpl(MTimeOut& i_cb) : cb(i_cb)
{
}

void CTimeOutImpl::ConstructL()
{
	iContext=MApp_context::Static();
	CALLSTACKITEM2(_L("CTimeOutImpl::ConstructL"), iContext);

	CTimer::ConstructL();
	CActiveScheduler::Add(this);
}

EXPORT_C CTimeOut* CTimeOut::NewL(MTimeOut& i_cb)
{
	CALLSTACKITEMSTATIC(_L("CTimeOutImpl::RunL"));

	auto_ptr<CTimeOutImpl> ret (new (ELeave) CTimeOutImpl(i_cb));
	ret->ConstructL();
	return ret.release();
}

void CTimeOutImpl::RunL()
{
	// there's no guarantee that we aren't deleted
	// from the expired() callback, so we have to cache
	// the member variable iContext in a stack variable

	MApp_context* ctx=iContext;
	if (ctx) ctx->ResetCallStack();
	CALLSTACKITEM2(_L("CTimeOutImpl::RunL"), iContext);

	TTime now; now.HomeTime(); 
	
	now+=TTimeIntervalMicroSeconds(100*1000);
	if (now < iWaitUntil) {
		At(iWaitUntil);
	} else {
		cb.expired(this);
	}

	if (ctx) ctx->ResetCallStack();
}

void CTimeOutImpl::Wait(int seconds)
{
	CALLSTACKITEM2(_L("CTimeOutImpl::Wait"), iContext);
	Reset();
	TTime at;
	at.HomeTime();
	
	at+=TTimeIntervalSeconds(seconds);
	iWaitUntil=at;
	At(at);
}

void CTimeOutImpl::Reset()
{
	CALLSTACKITEM2(_L("CTimeOutImpl::Reset"), iContext);

	Cancel();
}

CTimeOutImpl::~CTimeOutImpl()
{
	CALLSTACKITEM2(_L("CTimeOutImpl::~CTimeOutImpl"), iContext);

	iContext=0;
	Cancel();
}

EXPORT_C void SetTime()
{
	TTime now;
	now.HomeTime();
	now+=TTimeIntervalHours(3);
	User::SetHomeTime(now);
}