/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "xml.h"
#include "symbian_auto_ptr.h"

CXmlParser* CXmlParser::NewL(MXmlHandler& Handler)
{
	auto_ptr<CXmlParser> ret(new (ELeave) CXmlParser(Handler));
	ret->ConstructL();
	return ret.release();
}

void CXmlParser::Parse(const char* buf, int len, int isFinal)
{
	if (!XML_Parse(iParser, buf, len, isFinal)) {
		XML_Error code=XML_GetErrorCode(iParser);
		iHandler.Error(code, XML_ErrorString(code), XML_GetCurrentByteIndex(iParser));
	}
}

CXmlParser::~CXmlParser()
{
	XML_ParserFree(iParser);
}

void CXmlParser::StartElement(void *userData,
			   const XML_Char *name,
			   const XML_Char **atts)
{
	MXmlHandler* h=(MXmlHandler*)userData;
	h->StartElement(name, atts);
}

void CXmlParser::EndElement(void *userData,
			 const XML_Char *name)
{
	MXmlHandler* h=(MXmlHandler*)userData;
	h->EndElement(name);
}

void CXmlParser::CharacterData(void *userData,
			    const XML_Char *s,
			    int len)
{
	MXmlHandler* h=(MXmlHandler*)userData;
	h->CharacterData(s, len);
}

CXmlParser::CXmlParser(MXmlHandler& Handler) : iHandler(Handler)
{
}

void CXmlParser::ConstructL()
{
	iParser=XML_ParserCreate(0);
	XML_SetElementHandler(iParser, StartElement, EndElement);
	XML_SetCharacterDataHandler(iParser, CharacterData);
	XML_SetUserData(iParser, &iHandler);
}
