/*
* ============================================================================
*  Name     : CContextNoteContainer from ContextNoteContainer.h
*  Part of  : ContextNote
*  Created  : 16.7.2004 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

// INCLUDE FILES
#include "ContextNoteContainer.h"

#include <eiklabel.h>  // for example label control

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CContextNoteContainer::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void CContextNoteContainer::ConstructL(const TRect& aRect)
{
	CreateWindowL();
	
	iEdit=new (ELeave) CEikEdwin;
	iEdit->SetContainerWindowL( *this );
	iEdit->ConstructL();
	iEdit->AddEdwinObserverL(this);

	TRect r(aRect);
	r.Move(4, 4);
	r.Resize(-8, -8);
	iEdit->SetRect(r);
	iEdit->ActivateL();
	iEdit->SetFocus(ETrue);
	
	SetRect(aRect);
	ActivateL();
}

// Destructor
CContextNoteContainer::~CContextNoteContainer()
{
	delete iEdit;
	delete iBuf;
}

// ---------------------------------------------------------
// CContextNoteContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CContextNoteContainer::SizeChanged()
{
	TRect r(Rect());
	r.Move(4, 4);
	r.Resize(-8, -8);
	iEdit->SetRect(r);
}

// ---------------------------------------------------------
// CContextNoteContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CContextNoteContainer::CountComponentControls() const
{
	return 1; // return nbr of controls inside this container
}

// ---------------------------------------------------------
// CContextNoteContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CContextNoteContainer::ComponentControl(TInt aIndex) const
{
	switch ( aIndex )
        {
        case 0:
		return iEdit;
        default:
		return NULL;
        }
}

// ---------------------------------------------------------
// CContextNoteContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CContextNoteContainer::Draw(const TRect& aRect) const
{
	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

// ---------------------------------------------------------
// CContextNoteContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CContextNoteContainer::HandleControlEventL(
						CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
{
	// TODO: Add your control event handler code here
}

TKeyResponse CContextNoteContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	return iEdit->OfferKeyEventL(aKeyEvent, aType);
}

void CContextNoteContainer::HandleEdwinEventL(CEikEdwin* /*aEdwin*/, TEdwinEvent /*aEventType*/)
{
}

const TDesC& CContextNoteContainer::GetText()
{
	delete iBuf; iBuf=0;
	iBuf=HBufC::NewL(iEdit->TextLength());
	TPtr p=iBuf->Des();
	iEdit->GetText(p);
	return *iBuf;
}

// End of File