/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef __CONTEXTNOTIFY__
#define __CONTEXTNOTIFY__

#include <e32base.h>
#include <w32std.h>

#include "NotifyCommon.h"
#include "drawer.h"
#include "foreground.h"

class CContextNotify : public CServer
{
public:

	static CContextNotify* NewL();
	static CContextNotify* NewLC();
	~CContextNotify();

	static TInt ThreadFunction(TAny* aNone);
	
	void IncrementSessions();
	void DecrementSessions();

	void RunL();
	TInt CheckedRunError(TInt aError);

	CContextNotify(TInt aPriority) ;

	void ConstructL() ;

	static void PanicClient(const RMessage& aMessage, TContextNotifyPanic aReason);
	static void PanicServer(TContextNotifyPanic aReason);
	static void ThreadFunctionL();

	//-------------------------------------------------------------
	// communications ...
	//-------------------------------------------------------------
	
	void TerminateContextNotify();

	void CancelRequest(const RMessage &aMessage);

public:
	TInt AddIconL(TInt aIconHandle, TInt aMaskHandle);
	void ChangeIconL(TInt aId, TInt aIconHandle, TInt aMaskHandle);
	void RemoveIcon(TInt aId);

	void ReportError(TContextNotifyRqstComplete aErrorType, TDesC & aErrorCode, TDesC & aErrorValue);

	enum TEvent { ETerminated };
private:
	void NotifySessions(TEvent aEvent);

	TInt iSessionCount;
	CSharableSession *	NewSessionL(const TVersion &aVersion) const;

	RWsSession	iWsSession; bool ws_is_open;
	CDrawer*	iDrawer;
	CForeground*	iForeground;

};

#endif
