/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


// ContextCommon.h


#ifndef __NOTIFYCOMMON__
#define __NOTIFYCOMMON__

#include <e32base.h>


//--------------------- SERVER PANICS --------------------

//Panic Category
_LIT(KContextNotify, "ContextNotify");

//Panic Codes
enum TContextNotifyPanic
{
	EBadRequest,
	EBadDescriptor,
	ESrvCreateServer,
    	ECreateTrapCleanup
};


//--------------------- SERVER PARAM --------------------

_LIT(KContextNotifyName,"myContextNotify");
_LIT(KContextNotifySemaphoreName, "AmyContextNotifySemaphore");

//the server version. A version must be specified when 
//creating a session with the server
const TUint KContextNotifyMajorVersionNumber=0;
const TUint KContextNotifyMinorVersionNumber=1;
const TUint KContextNotifyBuildVersionNumber=1;


//opcodes used in message passing between client and server
enum TContextNotifyRqst
{
	ETerminateContextNotify,
	EAddIcon,
	ERemoveIcon,
	EChangeIcon,
		
	ECancel

};

//opcodes used by server to indicate which asynchronous service
//has completed
enum TContextNotifyRqstComplete
{
	ERequestCompleted = 1,
	EContextNotifyTerminated = -4
};


#endif // __NOTIFYCOMMON__

