/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef LIST_H_INCLUDED
#define LIST_H_INCLUDED 1

#include <symbian_auto_ptr.h>

template<typename Data> class CList {
public:
	struct Node {
		Data	Item;
		Node*	Next;
		Node(): Next(0) { }
	};
	Node	*iFirst, *iCurrent;
	TInt	iCount;
	Node* AppendL(Data Item) {
		auto_ptr<Node> n(new (ELeave) Node);
		n->Item=Item;
		if (iCurrent) {
			iCurrent->Next=n.release();
			iCurrent=iCurrent->Next;
		} else {
			iCurrent=iFirst=n.release();
		}
		iCount++;
		return iCurrent;
		
	}
	void DeleteNode(Node* ListNode, bool Destroy)
	{
		if (!ListNode) return;
		Node* n=iFirst, *prev=0;
		while (n!=ListNode) {
			prev=n;
			n=n->Next;
		}
		if (n) {
			if (prev) {
				prev->Next=n->Next;
				if (n==iCurrent) iCurrent=prev;
			} else {
				if (iCurrent==iFirst) iCurrent=0;
				iFirst=iFirst->Next;
			}
		}
		if (Destroy) delete n;
		iCount--;
	}

	void MoveToTop(Node* ListNode)
	{
		if (ListNode==iFirst) return;
		DeleteNode(ListNode, false);
		ListNode->Next=iFirst;
		iFirst=ListNode;
		iCount++;
	}

	static CList* NewL() {
		auto_ptr<CList> self(new (ELeave) CList);
		self->ConstructL();
		return self.release();
	}

	~CList() {
		reset();
	}
	void reset() {
		while (iFirst!=0) {
			Node* tmp=iFirst->Next;
			delete iFirst;
			iFirst=tmp;
		}
		iCurrent=0;
		iCount=0;
	}
	void DeleteFirst() {
		if (!iFirst) return;
		Node* tmp=iFirst;
		if (iCurrent==iFirst) {
			iCurrent=tmp->Next;
		}
		iFirst=tmp->Next;
		delete tmp;
		iCount--;
	}
	void DeleteLast()
	{
		if (!iCurrent) {
			User::Leave(-1005);
		}
		DeleteNode(iCurrent, true);
	}
	Data Top() {
		if (!iFirst) return Data();
		return iFirst->Item;
	}

	Data Pop() {
		if (!iFirst) {
			return Data();
		}

		Data ret=iFirst->Item;
		DeleteFirst();
		return ret;
	}
	void Push(Data Item) {
		auto_ptr<Node> n(new (ELeave) Node);
		n->Item=Item;
		n->Next=iFirst;
		iFirst=n.release();
		if (!iCurrent) iCurrent=iFirst;
		iCount++;
	}
private:
	CList() : iFirst(0), iCurrent(0), iCount(0) { }
	void ConstructL() { }
};

#endif
