/*
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


//CContextServerSession.h
#ifndef __CCONTEXTSERVERSESSION__
#define __CCONTEXTSERVERSESSION__

#include <e32base.h>
#include "ContextServer.h"

class CContextServerSession : public CSession
{

public: 
	static CContextServerSession* NewL(RThread& aClient, CContextServer& aServer);
	static CContextServerSession* NewLC(RThread& aClient, CContextServer& aServer);
	~CContextServerSession();
	
	void ServiceL(const RMessage& aMessage);

	void SendPresenceInfo(TDesC & presenceInfo);

private:
	CContextServerSession(RThread& aClient, CContextServer& aServer);
	void ConstructL() ;
	void PanicClient(TInt aPanic) const;

	void ConnectToPresenceServer(const RMessage & aMessage);
	void DisconnectFromPresenceServer(const RMessage & aMessage);
	void TerminateContextServer(const RMessage & aMessage);
	void HandleRequestPresenceInfo(const RMessage& aMessage);
	void HandleRequestPresenceNotification(const RMessage & aMessage);
	void UpdateUserPresence(const RMessage & aMessage);
	void SuspendConnection(const RMessage & aMessage);
	void ResumeConnection(const RMessage & aMessage);
	void HandleRequestMessageNotification(const RMessage& aMessage);

	void CompleteMessage(TInt Code);
	void SendPresenceInfo(const TPresenceInfo& info);
	void SendNewMessage(TMessage aJabberMessage);

public: // from MContextServerNotifier
	void NotifyEvent(CContextServer::TEvent aEvent);
	void ReportError(TContextServRqstComplete aErrorType, TDesC & aErrorCode, TDesC & aErrorValue);
private: 
	
	RMessage            iMessage; TInt iMessageThreadId;
	void SetMessage(const RMessage& aMsg);
	CContextServer&     iServer;
	RArray<TInt>	    iFlags;
};

#endif

