/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef POINTER_H_INCLUDED
#define POINTER_H_INCLUDED 1

#ifdef __SYMBIAN32__
#include <e32std.h>
#include "symbian_auto_ptr.h"

void memset(void* dest, int value, int len);
void* memmove(void* dest, const void* src, int len);

#else

#include <string.h>
#include <memory>
using std::auto_ptr;

enum TLeave { ELeave };
inline void* operator new (size_t s, TLeave) {
	return new char[s];
}
inline void* operator new[] (size_t s, TLeave) {
	return new char[s];
}

class CBase {
public:
	virtual ~CBase() { }
	void* operator new (size_t s) { void* ret; ret=new char[s]; memset(ret, 0, s); return ret; }
	void* operator new (size_t s, TLeave) { void* ret; ret=new char[s]; memset(ret, 0, s); return ret; }
};

#endif // __SYMBIAN__ 

#endif
