/* 
Copyright (C) 2004  Mika Raento - Renaud Petit

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
    
     email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/* Copyright (c) 2001, Nokia. All rights reserved */

#include "SocketsWriter.h"
#include "Sockets.pan"
#include "EngineNotifier.h"

#include <flogger.h>
#include <app_context.h>

void Log(const TDesC& msg);
void Log(const TDesC8& msg);
void Log(const TDesC& msg, TInt i);

const TInt CSocketsWriter::KTimeOut = 30; // 30 seconds time-out

CSocketsWriter* CSocketsWriter::NewL(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
{
	CALLSTACKITEM2(_L("CSocketsWriter::NewL"), &Context);

	CSocketsWriter* self = CSocketsWriter::NewLC(aEngineNotifier, aSocket, Context);
	CleanupStack::Pop(self);
	return self;
}


CSocketsWriter* CSocketsWriter::NewLC(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
{
	CALLSTACKITEM2(_L("CSocketsWriter::NewLC"), &Context);

	CSocketsWriter* self = new (ELeave) CSocketsWriter(aEngineNotifier, aSocket, Context);
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
}


CSocketsWriter::CSocketsWriter(MEngineNotifier& aEngineNotifier, RSocket& aSocket, MApp_context& Context)
: CActive(EPriorityStandard), MContextBase(Context),
iSocket(aSocket),
iEngineNotifier(aEngineNotifier)
{
	CALLSTACKITEM(_L("CSocketsWriter::CSocketsWriter"));

}


CSocketsWriter::~CSocketsWriter()
{
	CALLSTACKITEM(_L("CSocketsWriter::~CSocketsWriter"));

	Cancel();
	delete iTimer;
	delete iTransferBuffer;
	delete iWriteBuffer;
}

void CSocketsWriter::DoCancel()
{	
	CALLSTACKITEM(_L("CSocketsWriter::DoCancel"));

	// Cancel asychronous write request
	iSocket.CancelWrite();
	iTimer->Reset();
	iWriteStatus = EWaiting;
}

void CSocketsWriter::ConstructL()
{
	CALLSTACKITEM(_L("CSocketsWriter::ConstructL"));

	CActiveScheduler::Add(this);
	
	iTimeOut = KTimeOut; 
	iTimer = CTimeOut::NewL(*this);
	iWriteStatus = EWaiting;
	
	iTransferBuffer=HBufC8::NewL(1024);
	iWriteBuffer=HBufC8::NewL(1024);
}

void CSocketsWriter::expired(CBase*)
{
	CALLSTACKITEM(_L("CSocketsWriter::expired"));

	Cancel();
	iWriteStatus = EWaiting;
	iEngineNotifier.ReportError(MEngineNotifier::ETimeOutOnWrite, KErrTimedOut);
}

TInt CSocketsWriter::CheckedRunError(TInt aError)
{
	CALLSTACKITEM(_L("CSocketsWriter::CheckedRunError"));

	
	Log(_L("Error in CSocketsReader::RunL %d"), aError);
	return aError;
}

void CSocketsWriter::RunL()
{
	AppContext().ResetCallStack();

	CALLSTACKITEM(_L("CSocketsWriter::RunL"));

	iTimer->Cancel();
	
	// Active object request complete handler
	if (iStatus == KErrNone)
	{
		switch(iWriteStatus)
		{
			// Character has been written to socket
		case ESending:
			SendNextPacket();
			break;
		default:
			User::Panic(KPanicSocketsEngineWrite, ESocketsBadStatus);
			break;
		};
	}
	else 
	{
		// Error: pass it up to user interface
		iEngineNotifier.ReportError(MEngineNotifier::EGeneralWriteError, iStatus.Int());
		iWriteStatus = EWaiting;
	}

	AppContext().ResetCallStack();
}

void CSocketsWriter::IssueWriteL(const TDesC16& aData)
{
	CALLSTACKITEM(_L("CSocketsWriter::IssueWriteL"));

	
	RFileLogger iLog;
	iLog.Connect();
	iLog.CreateLog(_L("Context"),_L("Engine"),EFileLoggingModeAppend);
	iLog.Write(_L("Send:"));
	/*
	TInt half=aData.Length()/2;
	iLog.Write(aData.Left(half));
	iLog.Write(aData.Mid(half));
	*/
	iLog.CloseLog();
	iLog.Close();
	
	if ((iWriteStatus != EWaiting) && (iWriteStatus != ESending))
        {
		User::Leave(KErrNotReady);
        }
	
	while ((aData.Size() + iTransferBuffer->Des().Length()) > iTransferBuffer->Des().MaxLength())
        {
		// Not enough space in buffer
		iTransferBuffer=iTransferBuffer->ReAllocL(iTransferBuffer->Des().MaxLength()*2);
        }
	
	// Add new data to buffer
	iTransferBuffer->Des().Append( (TUint8*)aData.Ptr(), aData.Size());
	
	if (!IsActive())
        {
		SendNextPacket();
        }
}

void CSocketsWriter::SendNextPacket()
{
	CALLSTACKITEM(_L("CSocketsWriter::SendNextPacket"));

	
	if (iTransferBuffer->Length() > 0)
        {
		// Move data from transfer buffer to actual write buffer
		if (!iWriteBuffer ||  iWriteBuffer->Des().MaxLength() < iTransferBuffer->Length() ) {
			delete iWriteBuffer; iWriteBuffer=iTransferBuffer->Des().AllocL();
		} else {
			*iWriteBuffer=*iTransferBuffer;
		}
		iTransferBuffer->Des().Zero();
		iSocket.Write(*iWriteBuffer, iStatus); // Initiate actual write
		
		
		
		// Request timeout
		iTimer->Wait(iTimeOut);
		SetActive();
		iWriteStatus = ESending;
        }
	else
        {
		iWriteStatus = EWaiting;
        }
}
