/*
* ============================================================================
*  Name     : CTaskListAppUi from TaskListAppUi.cpp
*  Part of  : TaskList
*  Created  : 13.4.2004 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

// INCLUDE FILES
#include "TaskListAppUi.h"
#include "TaskListContainer.h" 
#include <TaskList.rsg>
#include "tasklist.hrh"
#include <aknmessagequerydialog.h>

#include <avkon.hrh>

// ================= MEMBER FUNCTIONS =======================
//
// ----------------------------------------------------------
// CTaskListAppUi::ConstructL()
// ?implementation_description
// ----------------------------------------------------------
//
void CTaskListAppUi::ConstructL()
{
	BaseConstructL();
	
	iThreadNames=new (ELeave) CDesC16ArrayFlat(4);
	iThreadIds=new (ELeave) CArrayFixFlat<TThreadId>(4);
	
	GetThreads();
	
	iAppContainer = new (ELeave) CTaskListContainer;
	iAppContainer->SetMopParent(this);
	iAppContainer->ConstructL( ClientRect(), iThreadNames, this );
	AddToStackL( iAppContainer );
}

// ----------------------------------------------------
// CTaskListAppUi::~CTaskListAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CTaskListAppUi::~CTaskListAppUi()
{
	if (iAppContainer)
        {
		RemoveFromStack( iAppContainer );
		delete iAppContainer;
        }
	delete iThreadNames;
	delete iThreadIds;
}

void CTaskListAppUi::GetThreads()
{
	TFindThread f(_L("*"));
	TFullName t;
	RThread r;
	iThreadNames->Reset();
	iThreadIds->Reset();
	while (f.Next(t)==KErrNone) {
		r.Open(t);
		CleanupClosePushL(r);
		iThreadNames->AppendL(t);
		iThreadIds->AppendL(r.Id());
		CleanupStack::PopAndDestroy();
	}
}

// ------------------------------------------------------------------------------
// CTaskListAppUi::::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CTaskListAppUi::DynInitMenuPaneL(
				      TInt /*aResourceId*/,CEikMenuPane* /*aMenuPane*/)
{
}

// ----------------------------------------------------
// CTaskListAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// ?implementation_description
// ----------------------------------------------------
//
TKeyResponse CTaskListAppUi::HandleKeyEventL(
					     const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
{
	return EKeyWasNotConsumed;
}

// ----------------------------------------------------
// CTaskListAppUi::HandleCommandL(TInt aCommand)
// ?implementation_description
// ----------------------------------------------------
//
void CTaskListAppUi::KillCurrent()
{
	TInt idx=iAppContainer ->GetCurrentIdx();
	TThreadId id=iThreadIds->At(idx);
	RThread t;
	t.Open(id);
	t.Kill(-1000);
	t.Close();
	GetThreads();
	iAppContainer->ContentsChanged();
}

void CTaskListAppUi::HandleCommandL(TInt aCommand)
{
	switch ( aCommand )
        {
        case EAknSoftkeyBack:
        case EEikCmdExit:
		{
			Exit();
			break;
		}
        case ETaskListCmdAppKill:
		{
			KillCurrent();
			break;
		}
		// TODO: Add Your command handling code here
		
	case ETaskListCmdAppRefresh:
		{
			GetThreads();
			iAppContainer->ContentsChanged();
		}
        default:
		break;      
        }
}

void CTaskListAppUi::HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType)
{
	TBuf<200> msg;
	
	TInt idx=iAppContainer ->GetCurrentIdx();
	TThreadId id=iThreadIds->At(idx);
	TUint i=id;
	RProcess p;
	RThread t;
	t.Open(id);

	TInt etype, ereason;
	TExitCategoryName ecat;
	etype=t.ExitType();
	ereason=t.ExitReason();
	ecat=t.ExitCategory();

	t.Process(p);
	t.Close();
	TUint pi=p.Id();
	msg.Format(_L("T Id: %x\nP Id: %x\nEType %d EReason %d\n ECat %S"), i, pi, etype, ereason, &ecat);
	CAknMessageQueryDialog* note=CAknMessageQueryDialog::NewL(msg);
	note->ExecuteLD(R_LOGVIEW_EVENT_DIALOG);
}

// End of File  