/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_APPLOGVIEW_H_INCLUDED
#define CL_APPLOGVIEW_H_INCLUDED 1

#include <aknview.h>
#include <eiktxlbx.h>
#include "circular.h"
#include <aknglobalnote.h> 
#include <aknnotewrappers.h> 

const TUid KLogViewId = {3};

class CLogContainer : public CCoeControl, MCoeControlObserver, public MListObserver {
public: // Constructors and destructor
        
	CLogContainer();
        void ConstructL(const TRect& aRect, CCircularLog* Log, MEikListBoxObserver* ListBoxObserver);
	
        ~CLogContainer();
	void ContentsChanged();
	
private: // Functions from base classes
	
        void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
	TKeyResponse OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType);
private: //data
        CEikTextListBox* iListBox;
	CCircularLog*	iLog;
};

class CAppLogView : public CAknView, public MEikListBoxObserver
{
public: // Constructors and destructor
	static CAppLogView* NewL(CCircularLog* Log);
        ~CAppLogView();
	
public: // Functions from base classes
        
        TUid Id() const;
	
        void HandleCommandL(TInt aCommand);
	
        void HandleClientRectChange();
	void SetLog(CCircularLog* Log);
	
private:
	CAppLogView();
        void ConstructL(CCircularLog* Log);
	
        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId,
		const TDesC8& aCustomMessage);
        void DoDeactivate();

	void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);
	
private: // Data
	CLogContainer*	iContainer;
	CCircularLog*	iLog;
};


#endif // CL_LOGVIEW_H_INCLUDED
