/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(LOCATIONING_H_INCLUDED)

#define LOCATIONING_H_INCLUDED

#include "sms.h"
#include "status_notif.h"
#include "app_context.h"
#include "list.h"
#include "ftp.h"
#include "presence_publisher.h"
#include <plpvariant.h>

class MNaming {
public:
	virtual void add_cellid_name(const TDesC& cellid, const TDesC& name) = 0;
};

class Clocationing: public CBase, public i_handle_received_sms, public MContextBase,
public MTimeOut, public MSettingListener {
public:
	Clocationing(MApp_context& Context);
	void ConstructL(i_status_notif* i_cb, MNaming* i_naming,sms* i_sms_handler, CPresencePublisher * aPublisher);
	void test();
	void GetNameL(const TDesC& CellId);
	const TDesC& GetImsi() const { return imsi; }
	bool LocationgAvailable() const { return (iLocationingAvailable && iEnabled); }

	static Clocationing* NewL(MApp_context& Context, i_status_notif* i_cb, MNaming* i_naming, sms* i_sms_handler, CPresencePublisher * aPublisher);
	~Clocationing();

	virtual void now_at_location(const TDesC& cell, TInt id, bool is_base, bool loc_changed, TTime time);
private:
	virtual bool handle_reception(const TMsvId& entry_id, const TMsvId& folder_id, const TDesC& sender, const TDesC& body); // return true if message is to be deleted
	virtual void handle_error(const TDesC& descr);
	virtual void handle_change(const TMsvId& msg_id, const TDesC& sender);
	virtual void handle_read(const TMsvId& msg_id, const TDesC& sender);
	virtual void handle_delete(const TMsvId& msg_id, const TMsvId& parent_folder, const TDesC& sender);
	virtual void handle_move(const TMsvId& msg_id, const TMsvId& from_folder, const TMsvId& to_folder, const TDesC& sender);
	virtual void handle_sending(const TMsvId& entry_id, const TDesC& sender, const TDesC& body);
	// MTimeOut
	virtual void expired(CBase*);
	
	// MSettingListener
	virtual void SettingChanged(TInt Setting);

	MNaming*	iNaming;

	struct TNamingRec {
		TBuf<50>	CellId;
		TTime		Time;
		bool		SentRequest;
		TNamingRec(const TDesC& i_CellId) : CellId(i_CellId), SentRequest(false) 
		{ 
			Time.HomeTime(); 
		}
		TNamingRec() { }
		void Reset() {
			CellId=_L("XX");
			SentRequest=false;
		}
	};

	TNamingRec	iToName;
	CTimeOut*	iTimer;
	int		iToDiscard;
	TBuf<20>	iName;
	bool		iLocationingAvailable; // RL network
	bool		iEnabled;
	enum TStyle { ENone, ERadiolinja, ESonera };
	TStyle		iStyle;

	TPlpVariantMachineId imsi;


	sms* smsh;
	CPresencePublisher * iPublisher;
	//sms_reception* smsh2;
	i_status_notif* cb;
	TInt		iRetryCount;
};

#endif

