/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(LOG_CELLID_H_INCLUDED)

#define LOG_CELLID_H_INCLUDED

#include "i_log_source.h"
#include "log_base_impl.h"

#include <e32base.h>
#include <etelbgsm.h>

#include "app_context.h"
#include "cellmap.h"

#ifdef __WINS__
#include "bases.h"
#endif

class Clog_cellid: public CCheckedActive, public Mlog_base_impl
{
public:
	~Clog_cellid();
	
	const TDesC& get_value();
	
	static Clog_cellid* NewL(MApp_context& Context, CCellMap& CellMap);
	bool call_in_progress();

private:
	virtual void DoCancel();
	virtual void CheckedRunL(); 
	virtual TInt CheckedRunError(TInt aError);
private:
	Clog_cellid(MApp_context& Context, CCellMap& CellMap);
	void ConstructL();
	
	HBufC* cellid_value;
	RLine line;
	MBasicGsmPhoneNetwork::TCurrentNetworkInfo async_info;
	MBasicGsmPhoneNetwork::TCurrentNetworkInfo prev_info;

	TInt	iErrorCount;
#ifdef __WINS__
	int test_data_i;
	RTimer timer;
#endif
};

#endif
