/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_LOG_LOCAL_H_INCLUDED
#define CL_LOG_LOCAL_H_INCLUDED 1

#include <e32base.h>
#include "log_base_impl.h"
#include "timeout.h"

class CLog_local : public CCheckedActive, public Mlog_base_impl, public MTimeOut {
public:
	static CLog_local* NewL(MApp_context& Context, const TDesC& name);
	~CLog_local();

	TRequestStatus* RequestStatus();
private:
	CLog_local(MApp_context& Context);
	void ConstructL(const TDesC& name);

	virtual void DoCancel();
	virtual void CheckedRunL(); 
	virtual TInt CheckedRunError(TInt aError);

	virtual void expired(CBase*);

	CTimeOut	*iTimer;
};

#endif
