/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#if !defined(LOG_TEST_H_INCLUDED)

#define LOG_TEST_H_INCLUDED

#include <e32base.h>
#include <MdaAudioSampleEditor.h>
#include <f32file.h>

class log_test : public CTimer, public MMdaObjectStateChangeObserver {
public:
	log_test();
	~log_test();

	void CheckedRunL();

	void ConstructL();
	void MoscoStateChangeEvent(CBase* /*aObject*/, TInt /*aPreviousState*/, TInt /*aCurrentState*/, TInt /*aErrorCode*/);
private:
	CMdaServer* audio_server;
	CMdaAudioRecorderUtility* recorder_util;
	
	enum state { IDLE, OPENING, STARTING_RECORD, RECORDING, STOPPING };
	state current_state;
	void stop(bool reset=false);
	void open();
	void record();
	void calculate();
	void set_timer(TInt seconds);

	TMdaWavClipFormat format;
	TMdaPcmWavCodec codec; 
	TMdaAudioDataSettings args;

	TBuf8<2*2*8000> buf;
	TMdaDesClipLocation clip;
	RFs sess;
	RFile file;

};

#endif
