/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CL_SMS_H_INCLUDED
#define CL_SMS_H_INCLUDED

#include <mtclbase.h>
#include <msvapi.h>
#include <mtclreg.h>
#include <smutset.h>

#include <etelbgsm.h>
#include <f32file.h>

#include "file_output_base.h"
#include "app_context.h"
#include "list.h"

#ifdef __WINS__
#include "ftp.h"
#endif

class i_handle_received_sms {
public:
	virtual bool handle_reception(const TMsvId& entry_id, const TMsvId& folder_id, const TDesC& sender, const TDesC& body) = 0; // return true if message is to be deleted
	virtual void handle_change(const TMsvId& msg_id, const TDesC& sender) = 0;
	virtual void handle_delete(const TMsvId& msg_id, const TMsvId& parent_folder, const TDesC& sender) = 0;
	virtual void handle_move(const TMsvId& msg_id, const TMsvId& from_folder, const TMsvId& to_folder, const TDesC& sender) = 0;
	virtual void handle_error(const TDesC& descr) = 0;
	virtual void handle_sending(const TMsvId& entry_id, const TDesC& sender, const TDesC& body) =0;
	virtual void handle_read(const TMsvId& msg_id, const TDesC& sender) = 0;
};

class dummyhandler;

class sms : public CCheckedActive, MMsvSessionObserver
#ifdef __WINS__
, public MTimeOut
#endif
 {
public:
	sms();
	~sms();
	void ConstructL();
	void CheckedRunL() { }
	void DoCancel() { }
	TInt send_message(const TDesC& recipient, const TDesC& body, bool keep_sent=true);
	//void set_reception_handler(i_handle_received_sms* handler);
	void AddHandler(i_handle_received_sms* handler);
protected:
	virtual void HandleSessionEventL(TMsvSessionEvent aEvent, TAny* aArg1, TAny* aArg2, TAny* aArg3);
	void handle_received(const TMsvId& entry_id, const TMsvId& folder_id);
	void handle_moved(const TMsvId& entry_id,const TMsvId& from_entry_id,const TMsvId& to_entry_id);
	void handle_changed(const TMsvId& entry_id);
	void handle_deleted(const TMsvId& entry_id, const TMsvId& parent_id);
	void handle_error(const TDesC& descr);
	void handle_sent(const TMsvId& entry_id);
	void handle_read(const TMsvId& msg_id);
	
private:
	void send_messageL(const TDesC& recipient, const TDesC& body, bool keep_sent=true);
	bool loadmessageL(const TMsvId& entry_id, TMsvEntry& entry);

	TBool DeleteSentEntry(TMsvId aEntryId);
	CMsvSession* iSession;
	CMsvSession* iReceiveSession;
	CClientMtmRegistry* iMtmReg;
	CClientMtmRegistry* iReceiveMtmReg;
	CBaseMtm*	iMtm;
	CBaseMtm*	iReceiveMtm;
	//i_handle_received_sms*	reception_handler;
	CSmsSettings* sendOptions;
	TBuf<50> state;
	CMsvOperation* op;
	TRequestStatus copy_rs;
	dummyhandler*	dummy;
		
	CList<i_handle_received_sms*>*	iHandlers;


#ifdef __WINS__
	CTimeOut*	iTimer;
	void expired(CBase*);
	int		iCount;
#endif
};



#endif
