/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef STATUSVIEW_H_INCLUDED
#define STATUSVIEW_H_INCLUDED 1

#include <aknview.h>
#include "app_context.h"
#include "context_logcontainer.h"
#include "cellmap.h"

// CONSTANTS
// UID of view
const TUid KStatusViewId = {1};

class CStatusView : public CAknView, public MContextBase
    {
    public: // Constructors and destructor
	static CStatusView* NewL(MApp_context& Context, CCellMap& CellMap);

        ~CStatusView();
	CContext_logContainer* Container() { return iContainer; }

    public: 
        
        TUid Id() const;
        void HandleCommandL(TInt aCommand);
        void HandleClientRectChange();
	TVwsViewId	iNextViewId; // kludge to make multiple switches from uploadview

    private:
	CStatusView(MApp_context& Context) : MContextBase(Context) { }
        void ConstructL(CCellMap& CellMap);

        void DoActivateL(const TVwsViewId& aPrevViewId,TUid aCustomMessageId,
            const TDesC8& aCustomMessage);
        void DoDeactivate();
	void DynInitMenuPaneL(
			 TInt aResourceId,CEikMenuPane* aMenuPane);
	
    private: // Data
        CContext_logContainer* iContainer;
	TUid id;
	bool iActive;
    };

#endif
