/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


/*
* ============================================================================
*  Name     : CContext_logContainer from Context_logContainer.h
*  Part of  : context_log
*  Created  : 13.2.2003 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

// INCLUDE FILES
#include "Context_logContainer.h"

#include <eiklabel.h>  // for example label control
#include <eikenv.h>

#include "cl_settings.h"
#include "basestack.h"



// ================= MEMBER FUNCTIONS =======================

void CContext_logContainer::register_source(const TDesC& name, const TDesC& initial_value, const TTime& time)
{
	CALLSTACKITEM(_L("CContext_logContainer::register_source"));

	if (! name.Compare(KLog_cellid) ) {
		register_source(_L("cell name"), _L(""), time);
	}

	CEikLabel* label;
	
	int this_label_index=label_store->Count()+1;

	label = new (ELeave) CEikLabel;
	CleanupStack::PushL(label);
	label->SetContainerWindowL( *this );
	label->SetFont(CEikonEnv::Static()->DenseFont());
	label->SetTextL( name );
	log_labels.addL(name, label);
	label_store->AppendL(label);
	CleanupStack::Pop();
	label->SetExtent( TPoint(10, this_label_index*12), TSize(50, 12));
	
	
	label = new (ELeave) CEikLabel;
	CleanupStack::PushL(label);
	label->SetContainerWindowL( *this );
	label->SetFont(CEikonEnv::Static()->DenseFont());
	label->SetTextL( initial_value );
	log_values.addL(name, label);
	value_store->AppendL(label);
	CleanupStack::Pop();
	label->SetExtent( TPoint(65, this_label_index*12), TSize(100, 12));
	
	if (initial_value.Length()) {
		new_value(Mlogger::VALUE, name, initial_value, time);
	}
	DrawNow();
}

void delete_bufc(void* data)
{
	HBufC* p;
	p=(HBufC*)data;
	delete p;
}

CContext_logContainer::CContext_logContainer(MApp_context& Context, CCellMap& CellMap) : 
	Mlog_base_impl(Context), iCellMap(CellMap)
{
	CALLSTACKITEM(_L("CContext_logContainer::CContext_logContainer"));

}

void CContext_logContainer::new_value(log_priority priority, const TDesC& name, const TDesC& value, const TTime& time)
{
	CALLSTACKITEM(_L("CContext_logContainer::new_value"));


	CEikLabel* label;
	label=(CEikLabel*)log_values.find(name);
	if (!label) return;
		
	if (! name.Compare(KLog_cellid) && priority==Mlogger::VALUE) {
		TInt id=iCellMap.GetId(value);
		HBufC* user_given_name=0;
		user_given_name=(HBufC*)cellid_names->GetData(id);
		CEikLabel* name_label=(CEikLabel*)log_values.find(_L("cell name"));
		if (user_given_name) {
			current_name=*user_given_name;
			if (name_label) {
				name_label->SetTextL(*user_given_name);
				if (id==iBase[0].iBaseId && iBase[0].iLeft==TTime(0)) 
					name_label->SetUnderlining(ETrue);
				else
					name_label->SetUnderlining(EFalse);
			}
		} else {
			TBuf<200> tmp;
			if (current_name.Length()) {
				tmp.Format(_L("last: %S"), &current_name);
			}
			if (name_label) name_label->SetTextL(tmp);
			name_label->SetUnderlining(EFalse);
		}
	}
	if (! name.Compare(_L("base")) && priority==Mlogger::VALUE) {
#ifdef __WINS__
		TBuf<20> t;
		_LIT(KFormatTxt,"%04d%02d%02dT%02d%02d%02d ");
		TDateTime dt;
		dt=time.DateTime();
		t.Format(KFormatTxt, dt.Year(), (TInt)dt.Month()+1, (TInt)dt.Day()+1,
			dt.Hour(), dt.Minute(), dt.Second());
		RDebug::Print(t); RDebug::Print(value);
#endif
		if (value.Length()==0 && !(label->Text()->Left(5).Compare(_L("last:")))) return;
	}
	label->SetTextL(value);
	DrawNow();
}

void CContext_logContainer::unregister_source(const TDesC& /*name*/, const TTime& /*time*/)
{
	CALLSTACKITEM(_L("CContext_logContainer::unregister_source"));

	//TODO
}

void CContext_logContainer::add_cellid_name(const TDesC& cellid, const TDesC& name)
{
	CALLSTACKITEM(_L("CContext_logContainer::add_cellid_name"));

	HBufC* n=HBufC::NewL(name.Length());
	CleanupStack::PushL(n);
	*n=name;
	TInt id=iCellMap.GetId(cellid);
	cellid_names->AddDataL(id, (void*)n, true); 
	CleanupStack::Pop(); // n

	CEikLabel* label=(CEikLabel*)log_values.find(_L("cell name"));
	CEikLabel* id_label=(CEikLabel*)log_values.find(KLog_cellid);
	if (label && id_label && (! id_label->Text()->Compare(cellid))) {
		label->SetTextL(name);
		DrawNow();
	}
	TInt id_for_cell=iCellMap.GetId(cellid);
	label=(CEikLabel*)log_values.find(_L("base"));
	if (id_for_cell==current_cell && iBase[0].iLeft==TTime(0) && label) {
		label->SetTextL(name);
		DrawNow();
	}
	TTime now; now.HomeTime();

	if (id_for_cell==current_cell && iBase[0].iLeft==TTime(0)) {
		now_at_location(cellid, id_for_cell, true, false, iBase[0].iEntered);
	}
}

bool CContext_logContainer::is_named(const TInt id)
{
	CALLSTACKITEM(_L("CContext_logContainer::is_named"));

	if (cellid_names->GetData(id)) return true;
	return false;
}

void CContext_logContainer::now_at_location(const TDesC& cellid, TInt id, bool is_base, bool loc_changed, TTime time)
{
	CALLSTACKITEM(_L("CContext_logContainer::now_at_location"));

	current_cell=id;

	TBuf<60> tmp;
	if (iFirstLoc) {
		iFirstLoc=false;
		/*
		 * get the stored last base and post
		 */
		int previ=1;
		if (iBase[0].iLeft!=TTime(0)) {
			previ=0;
		}
		tmp=_L("last: ");
		tmp.Append(iBase[previ].iBaseName);
		post_new_value(tmp, iBase[previ].iLeft);

		TTime iBaseStamp, now;
		now.HomeTime(); now-=TTimeIntervalMinutes(15);
		Settings().GetSettingL(SETTING_LAST_BASE_STAMP, iBaseStamp);

		if (iBase[0].iBaseId==-1 && is_base) {
			// no previous data
			HBufC* user_given_name=0;
			user_given_name=(HBufC*)cellid_names->GetData(id);
			if (user_given_name) {
				iBase[0]=CBaseStack::TBaseItem(id, *user_given_name, time);
			} else {
				iBase[0]=CBaseStack::TBaseItem(id, _L(""), time);
			}
			iBaseStack->PushBackL(iBase[0]);
			post_new_value(iBase[0].iBaseName, iBase[0].iEntered);
			AddToLog(iBase[0]);
		} else if (id==iBase[0].iBaseId && now < iBaseStamp && (iBase[0].iLeft==TTime(0) || now < iBase[0].iLeft)) {
			iBase[0].iLeft=0; iBaseStack->SetLastLeft(TTime(0));
			post_new_value(iBase[0].iBaseName, iBase[0].iEntered);
			ReplaceLastLog(iBase[0]);
			Settings().WriteSettingL(SETTING_LAST_BASE_STAMP, time);
			return;
		}
	}

	Settings().WriteSettingL(SETTING_LAST_BASE_STAMP, time);

	if (loc_changed) {
		// did we stay long enough to count in current base
		if (iBase[0].iLeft==TTime(0)) {
			if (iBase[0].iEntered+TTimeIntervalMinutes(10) > time) {
				// didn't stay
				iBaseStack->DeleteLastL();
				if (iBaseLog) iBaseLog->DeleteLast();
				if (iBaseStack->LastL(iBase[0]))
					iBaseStack->PrevL(iBase[1]);
			} else {
				iBase[0].iLeft=time;
				iBaseStack->SetLastLeft(time);
				tmp=_L("last: ");
				tmp.Append(iBase[0].iBaseName);
				post_new_value(tmp, iBase[0].iLeft);
				ReplaceLastLog(iBase[0]);
			}
		}

		// did we come back to previous
		TTime comp=time; comp-=TTimeIntervalMinutes(15);
		int previ=1;
		if (iBase[0].iLeft!=TTime(0)) previ=0;
		if (is_base && iBase[previ].iBaseId==id && comp < iBase[previ].iLeft) {
			// came back to previous quickly
			if (previ==0) {
				iBase[0].iLeft=0;
				iBaseStack->SetLastLeft(TTime(0));
			} else {
				iBaseStack->DeleteLastL();
				if (iBaseStack->LastL(iBase[0]))
					iBaseStack->PrevL(iBase[1]);
				if (iBaseLog) iBaseLog->DeleteLast();
			}
			tmp=_L("last: ");
			tmp.Append(iBase[1].iBaseName);
			post_new_value(tmp, iBase[1].iLeft);
			ReplaceLastLog(iBase[0]);
		}

		// what base are we in now
		if (is_base && iBase[0].iBaseId!=id) {			
			iBase[1]=iBase[0];
			HBufC* user_given_name=0;
			user_given_name=(HBufC*)cellid_names->GetData(id);
			if (user_given_name) {
				iBase[0]=CBaseStack::TBaseItem(id, *user_given_name, time);
			} else {
				iBase[0]=CBaseStack::TBaseItem(id, _L(""), time);
			}
			iBaseStack->PushBackL(iBase[0]);
			AddToLog(iBase[0]);
		}

		// prune stack
		while (iBaseStack->CountL()>20) {
			iBaseStack->DeleteFirstL();
		}
	} else {
		// skip if not changed location and no new name
		HBufC* user_given_name=0;
		user_given_name=(HBufC*)cellid_names->GetData(iBase[0].iBaseId);
		if (user_given_name==0) return;
		if (! ((*user_given_name).Left(50).Compare(iBase[0].iBaseName)) ) return;
		iBase[0].iBaseName=user_given_name->Left(50);
		iBaseStack->SetLastName(*user_given_name);
		ReplaceLastLog(iBase[0]);
	}

	// always post value, so that naming works
	if (iBase[0].iLeft==TTime(0)) {
		post_new_value(iBase[0].iBaseName, iBase[0].iEntered);
	}/* else {
		post_new_value(_L(""), iBase[0].iLeft);
	}*/
	
}

void CContext_logContainer::ReplaceLastLog(const CBaseStack::TBaseItem& b)
{
	if (!iBaseLog) return;

	iBaseLog->DeleteLast();
	AddToLog(b);
}

void CContext_logContainer::AddToLog(const CBaseStack::TBaseItem& b)
{
	if (!iBaseLog) return;

	TBuf<80> s;
	TDateTime ent=b.iEntered.DateTime();
	TDateTime left=b.iLeft.DateTime();
	if (b.iLeft!=TTime(0)) {
		s.Format(_L("%S %02d/%02d %02d:%02d - %02d/%02d %02d:%02d"), &(b.iBaseName), 
			(TInt)ent.Day()+1, (TInt)ent.Month()+1, (TInt)ent.Hour(), (TInt)ent.Minute(),
			(TInt)left.Day()+1, (TInt)left.Month()+1, (TInt)left.Hour(), (TInt)left.Minute());
	} else {
		s.Format(_L("%S %02d/%02d %02d:%02d -"), &(b.iBaseName),
			(TInt)ent.Day()+1, (TInt)ent.Month()+1, (TInt)ent.Hour(), (TInt)ent.Minute());
	}
	iBaseLog->AddL(s);
}

void CContext_logContainer::ReconstructLog()
{
	if (!iBaseLog) return;

	CBaseStack::TBaseItem b;
	if (iBaseStack->FirstL(b)) {
		AddToLog(b);
		while (iBaseStack->NextL(b)) {
			AddToLog(b);
		}
	}
}

CCircularLog*	CContext_logContainer::BaseLog()
{
	return iBaseLog;
}

void CContext_logContainer::ConstructL(const TRect& aRect)
{
	CALLSTACKITEM(_L("CContext_logContainer::ConstructL"));

#ifndef REALLY_ONLY_LOGGING
	iBaseLog=CCircularLog::NewL(20, true);
#endif

	iBaseStack=CBaseStack::NewL(AppContext());

	ReconstructLog();

	if (iBaseStack->LastL(iBase[0])) {
		iBaseStack->PrevL(iBase[1]);
	}

	iFirstLoc=true;

	cellid_names=CGenericIntMap::NewL();
	cellid_names->SetDeletor(delete_bufc);

	CreateWindowL();
	
	label_store=new (ELeave) CArrayFixFlat<CEikLabel*>(1);
	value_store=new (ELeave) CArrayFixFlat<CEikLabel*>(1);
	log_labels.ConstructL();
	log_values.ConstructL();
	
	status_label=new (ELeave) CEikLabel;
	status_label->SetContainerWindowL(*this);
	status_label->SetFont(CEikonEnv::Static()->DenseFont());
	status_label->SetTextL( _L("starting") );
	status_label->SetExtent(TPoint(10, 108), status_label->MinimumSize());
	
	err_label=new (ELeave) CEikLabel;
	err_label->SetContainerWindowL(*this);
	err_label->SetFont(CEikonEnv::Static()->DenseFont());
	err_label->SetTextL( _L("    ") );
	err_label->SetExtent(TPoint(10, 120), err_label->MinimumSize());

	Mlog_base_impl::ConstructL(KLog_cellname, _L("%S"));

	SetRect(aRect);
	ActivateL();
}

const TDesC& CContext_logContainer::get_value()
{
	CALLSTACKITEM(_L("CContext_logContainer::get_value"));

	return current_name;
}


// Destructor
CContext_logContainer::~CContext_logContainer()
{
	CALLSTACKITEM(_L("CContext_logContainer::~CContext_logContainer"));

	delete iLabel;
	delete status_label;
	delete err_label;
	if (label_store) {
		TInt count=label_store->Count();
		for (int i=count-1; i>=0; i--)  {
			delete (*label_store)[i];
		}
		delete label_store;
	}
	if (value_store) {
		TInt count=value_store->Count();
		for (int i=count-1; i>=0; i--)  {
			delete (*value_store)[i];
		}
		delete value_store;
	}
	delete cellid_names;
	delete iBaseStack;
	delete iBaseLog;
}

void CContext_logContainer::set_status(const TDesC& status)
{
	CALLSTACKITEM(_L("CContext_logContainer::set_status"));

	status_label->SetTextL(status);
	status_label->SetExtent(TPoint(10, 108), status_label->MinimumSize());
	DrawNow();
}

void CContext_logContainer::set_error(const TDesC& err)
{
	CALLSTACKITEM(_L("CContext_logContainer::set_error"));

	err_label->SetTextL(err);
	err_label->SetExtent(TPoint(10, 120), err_label->MinimumSize());
	DrawNow();
}

// ---------------------------------------------------------
// CContext_logContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CContext_logContainer::SizeChanged()
{
	CALLSTACKITEM(_L("CContext_logContainer::SizeChanged"));

	// TODO: Add here control resize code etc.
	//iLabel->SetExtent( TPoint(10,10), iLabel->MinimumSize() );
	status_label->SetExtent(TPoint(10, 108), status_label->MinimumSize());
	err_label->SetExtent(TPoint(10, 120), status_label->MinimumSize());
	
	if (!label_store) return;
	
	for (int i=0; i<label_store->Count(); i++)  {
		(*label_store)[i]->SetExtent( TPoint(10, (i)*12), TSize(50, 12) );
		(*value_store)[i]->SetExtent( TPoint(65, (i)*12), 
			(*value_store)[i]->MinimumSize() );
	}	
}

// ---------------------------------------------------------
// CContext_logContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CContext_logContainer::CountComponentControls() const
{
	CALLSTACKITEM(_L("CContext_logContainer::CountComponentControls"));

	if (!label_store) return 2;
	
	return label_store->Count()+value_store->Count()+2; // return nbr of controls inside this container
}

// ---------------------------------------------------------
// CContext_logContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CContext_logContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM(_L("CContext_logContainer::ComponentControl"));

	if (aIndex==0) {
		return status_label;
	}
	--aIndex;

	if (aIndex==0) {
		return err_label;
	} else if (label_store && aIndex>0 && aIndex <= label_store->Count()) {
		return (*label_store)[aIndex-1];
	} else if (label_store && aIndex>label_store->Count() && aIndex <= 
		label_store->Count()+value_store->Count()) {
		return (*value_store)[aIndex-label_store->Count()-1];
	} else {
		return NULL;
	}
}


// ---------------------------------------------------------
// CContext_logContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CContext_logContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM(_L("CContext_logContainer::Draw"));

	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbGray);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

// ---------------------------------------------------------
// CContext_logContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CContext_logContainer::HandleControlEventL(
						CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
{
	CALLSTACKITEM(_L("CContext_logContainer::HandleControlEventL"));

	// TODO: Add your control event handler code here
}

_LIT(CLASS_NAME, "CContext_logContainer");

const TDesC& CContext_logContainer::name() const
{
	CALLSTACKITEM(_L("CContext_logContainer::name"));

	return CLASS_NAME;
}

// End of File  
