/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "applogview.h"
#include "symbian_auto_ptr.h"
#include <context_log.rsg>
#include "context_log.hrh"
#include <aknviewappui.h> 
#include <eiktxlbm.h>
#include <aknmessagequerydialog.h>

#include "app_context.h"

// ================= MEMBER FUNCTIONS =======================

CLogContainer::CLogContainer()
{
	CALLSTACKITEM(_L("CLogContainer::CLogContainer"));

}

void CLogContainer::ConstructL(const TRect& aRect, CCircularLog* Log, MEikListBoxObserver* ListBoxObserver)
{
	CALLSTACKITEM(_L("CLogContainer::ConstructL"));

	iLog=Log;
	iLog->SetObserver(this);

	CreateWindowL(); 

	iListBox = new (ELeave) CEikTextListBox;
	iListBox->SetMopParent(this);
	iListBox->ConstructL(this, 0);
	
	iListBox->Model()->SetItemTextArray(iLog);
	iListBox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray);
	iListBox->CreateScrollBarFrameL(ETrue);
	iListBox->ScrollBarFrame()->SetScrollBarVisibilityL( CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto);

	iListBox->MakeVisible(ETrue);
	iListBox->SetRect(aRect);
	iListBox->ActivateL();
	iListBox->DrawNow();

	iListBox->SetListBoxObserver(ListBoxObserver);

	SetRect(aRect);
	ActivateL();
}
CLogContainer::~CLogContainer()
{
	CALLSTACKITEM(_L("CLogContainer::~CLogContainer"));

	iLog->SetObserver(0);
	delete iListBox;
}
void CLogContainer::SizeChanged()
{
	CALLSTACKITEM(_L("CLogContainer::SizeChanged"));

	iListBox->SetRect(Rect());
}

TInt CLogContainer::CountComponentControls() const
{
	CALLSTACKITEM(_L("CLogContainer::CountComponentControls"));

	return 1;
}

CCoeControl* CLogContainer::ComponentControl(TInt aIndex) const
{
	CALLSTACKITEM(_L("CLogContainer::ComponentControl"));

	if (aIndex==0) return iListBox;
	return 0;
}

void CLogContainer::Draw(const TRect& aRect) const
{
	CALLSTACKITEM(_L("CLogContainer::Draw"));

	CWindowGc& gc = SystemGc();
	// TODO: Add your drawing code here
	// example code...
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.DrawRect(aRect);
}

void CLogContainer::HandleControlEventL(
						CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
{
	CALLSTACKITEM(_L("CLogContainer::HandleControlEventL"));

	// TODO: Add your control event handler code here
}

void CLogContainer::ContentsChanged()
{
	CALLSTACKITEM(_L("CLogContainer::ContentsChanged"));

	TRAPD(err,
		if (iListBox) iListBox->HandleItemRemovalL();
		iListBox->DrawNow());
}

TKeyResponse CLogContainer::OfferKeyEventL(const TKeyEvent &aKeyEvent, TEventCode aType)
{
	CALLSTACKITEM(_L("CLogContainer::OfferKeyEventL"));

	return iListBox->OfferKeyEventL(aKeyEvent, aType);
}

CAppLogView* CAppLogView::NewL(CCircularLog* Log)
{
	CALLSTACKITEM(_L("CAppLogView::NewL"));

	auto_ptr<CAppLogView> ret(new (ELeave) CAppLogView);
	ret->ConstructL(Log);
	return ret.release();
}

CAppLogView::CAppLogView()
{
	CALLSTACKITEM(_L("CAppLogView::CAppLogView"));

}

// ---------------------------------------------------------
// CAppLogView::ConstructL(const TRect& aRect)
// EPOC two-phased constructor
// ---------------------------------------------------------
//
void CAppLogView::ConstructL(CCircularLog* Log)
{
	CALLSTACKITEM(_L("CAppLogView::ConstructL"));

	BaseConstructL( R_LOGVIEW_VIEW );
	iLog=Log;
}


// ---------------------------------------------------------
// CAppLogView::~CAppLogView()
// ?implementation_description
// ---------------------------------------------------------
//
CAppLogView::~CAppLogView()
{
	CALLSTACKITEM(_L("CAppLogView::ConstructL"));

	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
}

// ---------------------------------------------------------
// TUid CAppLogView::Id()
// ?implementation_description
// ---------------------------------------------------------
//
TUid CAppLogView::Id() const
{
	CALLSTACKITEM(_L("CAppLogView::Id"));

	return KLogViewId;
}

// ---------------------------------------------------------
// CAppLogView::HandleCommandL(TInt aCommand)
// ?implementation_description
// ---------------------------------------------------------
//
void CAppLogView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM(_L("CAppLogView::HandleCommandL"));

	switch ( aCommand )
        {
        case EAknSoftkeyClose:
			AppUi()->HandleCommandL( Econtext_logCmdlogviewClose );
		break;
	
		

        default:
		// TODO
		//AppUi()->HandleCommandL( Econtext_logCmdSettingsCancel );
		break;
        }
}

// ---------------------------------------------------------
// CAppLogView::HandleClientRectChange()
// ---------------------------------------------------------
//
void CAppLogView::HandleClientRectChange()
{
	CALLSTACKITEM(_L("CAppLogView::HandleClientRectChange"));

	if ( iContainer )
        {
		iContainer->SetRect( ClientRect() );
        }
}

void CAppLogView::SetLog(CCircularLog* Log)
{
	iLog=Log;
}

// ---------------------------------------------------------
// CAppLogView::DoActivateL(...)
// ?implementation_description
// ---------------------------------------------------------
//
void CAppLogView::DoActivateL(
				const TVwsViewId& /*aPrevViewId*/,TUid /*aCustomMessageId*/,
				const TDesC8& /*aCustomMessage*/)
{
	CALLSTACKITEM(_L("CAppLogView::DoActivateL"));

	if (!iContainer) {
		iContainer=new (ELeave) CLogContainer;
		iContainer->SetMopParent(this);
		iContainer->ConstructL( ClientRect(), iLog, this );
		AppUi()->AddToStackL( *this, iContainer );
        } 
}

// ---------------------------------------------------------
// CAppLogView::HandleCommandL(TInt aCommand)
// ?implementation_description
// ---------------------------------------------------------
//
void CAppLogView::DoDeactivate()
{
	CALLSTACKITEM(_L("CAppLogView::DoDeactivate"));

	if ( iContainer )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
	iContainer = 0;
}

void CAppLogView::HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType)
{
	if (aEventType== EEventEnterKeyPressed) {
		TInt idx=aListBox->CurrentItemIndex();
		TPtrC16 event=iLog->MdcaPoint(idx);
		auto_ptr<CAknMessageQueryDialog> note(CAknMessageQueryDialog::NewL(event));
		note.release()->ExecuteLD(R_LOGVIEW_EVENT_DIALOG);
	}
}

// End of File
