#include "basestack.h"
#include <db.h>

class CBaseStackImpl : public CBaseStack, public MContextBase, public MDBStore {
private:
	CBaseStackImpl(MApp_context& Context, CDb* Db);
	void ConstructL();
	~CBaseStackImpl();

	virtual void DeleteLastL();
	virtual void DeleteFirstL();
	virtual TBool LastL(TBaseItem& anItem);
	virtual TBool PrevL(TBaseItem& anItem);
	virtual TBool FirstL(TBaseItem& anItem);
	virtual TBool NextL(TBaseItem& anItem);
	virtual void PushBackL(const TBaseItem& anItem);
	virtual TInt CountL();
	virtual void SetLastLeft(const TTime& aLeft);
	virtual void SetLastName(const TDesC& aName);
	
	void Read(TBaseItem& anItem);
	void Write(const TBaseItem& anItem);

	CDb*	iDb;

	friend class CBaseStack;
};

CBaseStack* CBaseStack::NewL(MApp_context& Context)
{
	CALLSTACKITEM2(_L("CBaseStack::NewL"), &Context);

	CDb *db=CDb::NewL(Context, _L("BASESTACK"), EFileRead|EFileWrite|EFileShareAny);
	CleanupStack::PushL(db);
	CBaseStackImpl* s=new (ELeave) CBaseStackImpl(Context, db);
	CleanupStack::Pop();
	CleanupStack::PushL(s);
	s->ConstructL();
	CleanupStack::Pop();
	return s;
}

CBaseStack::~CBaseStack()
{
	CALLSTACKITEM(_L("CBaseStack::~CBaseStack"));

}

CBaseStack::TBaseItem::TBaseItem() : iBaseId(-1), iBaseName(), iEntered(0), iLeft(0)
{
	CALLSTACKITEM(_L("CBaseStack::TBaseItem"));

}

CBaseStack::TBaseItem::TBaseItem(const TBaseItem& anItem)
{
	CALLSTACKITEM(_L("CBaseStack::TBaseItem"));

	iBaseId=anItem.iBaseId;
	iBaseName=anItem.iBaseName;
	iEntered=anItem.iEntered;
	iLeft=anItem.iLeft;
}

CBaseStack::TBaseItem::TBaseItem(TInt aBaseId, const TDesC& aBaseName, const TTime& anEntered) : iLeft(0)
{
	CALLSTACKITEM(_L("CBaseStack::TBaseItem"));

	iBaseId=aBaseId;
	iBaseName=aBaseName;
	iEntered=anEntered;
}

CBaseStackImpl::CBaseStackImpl(MApp_context& Context, CDb* Db) : MContextBase(Context), MDBStore(Db->Db()), iDb(Db)
{
	CALLSTACKITEM(_L("CBaseStackImpl::CBaseStackImpl"));

}

void CBaseStackImpl::ConstructL()
{
	CALLSTACKITEM(_L("CBaseStackImpl::ConstructL"));

	int columns[] = { EDbColUint32, EDbColText16, EDbColDateTime, EDbColDateTime, -1 };
	int id_cols[] = { -1 };

	MDBStore::ConstructL(columns, id_cols, false, _L("basestack"));
}

CBaseStackImpl::~CBaseStackImpl()
{
	CALLSTACKITEM(_L("CBaseStackImpl::~CBaseStackImpl"));

	delete iDb;
}

void CBaseStackImpl::DeleteLastL()
{
	CALLSTACKITEM(_L("CBaseStackImpl::DeleteLastL"));

	if (iTable.LastL()) {
		iTable.DeleteL();
		//PutL();
	}
}

void CBaseStackImpl::DeleteFirstL()
{
	CALLSTACKITEM(_L("CBaseStackImpl::DeleteFirstL"));

	if (iTable.FirstL()) {
		iTable.DeleteL();
		//PutL();
	}
}

TBool CBaseStackImpl::LastL(TBaseItem& anItem)
{
	CALLSTACKITEM(_L("CBaseStackImpl::LastL"));

	if (iTable.LastL()) {
		iTable.GetL();
		Read(anItem);
		return ETrue;
	}
	return EFalse;
}

TBool CBaseStackImpl::PrevL(TBaseItem& anItem)
{
	CALLSTACKITEM(_L("CBaseStackImpl::PrevL"));

	if (iTable.PreviousL()) {
		iTable.GetL();
		Read(anItem);
		return ETrue;
	}
	return EFalse;
}

TBool CBaseStackImpl::FirstL(TBaseItem& anItem)
{
	CALLSTACKITEM(_L("CBaseStackImpl::FirstL"));

	if (iTable.FirstL()) {
		iTable.GetL();
		Read(anItem);
		return ETrue;
	}
	return EFalse;
}

TBool CBaseStackImpl::NextL(TBaseItem& anItem)
{
	CALLSTACKITEM(_L("CBaseStackImpl::NextL"));

	if (iTable.NextL()) {
		iTable.GetL();
		Read(anItem);
		return ETrue;
	}
	return EFalse;
}

void CBaseStackImpl::PushBackL(const TBaseItem& anItem)
{
	CALLSTACKITEM(_L("CBaseStackImpl::PushBackL"));

	iTable.LastL();
	iTable.InsertL();
	Write(anItem);
	PutL();
}

TInt CBaseStackImpl::CountL()
{
	CALLSTACKITEM(_L("CBaseStackImpl::CountL"));

	return iTable.CountL();
}

void CBaseStackImpl::Read(TBaseItem& anItem)
{
	CALLSTACKITEM(_L("CBaseStackImpl::Read"));

	anItem.iBaseId=iTable.ColUint(1);
	anItem.iBaseName=iTable.ColDes(2);
	anItem.iEntered=iTable.ColTime(3);
	anItem.iLeft=iTable.ColTime(4);
}

void CBaseStackImpl::Write(const TBaseItem& anItem)
{
	CALLSTACKITEM(_L("CBaseStackImpl::Write"));

	iTable.SetColL(1, anItem.iBaseId);
	iTable.SetColL(2, anItem.iBaseName.Left(50));
	iTable.SetColL(3, anItem.iEntered);
	iTable.SetColL(4, anItem.iLeft);
}

void CBaseStackImpl::SetLastLeft(const TTime& aLeft)
{
	CALLSTACKITEM(_L("CBaseStackImpl::SetLastLeft"));

	if (iTable.LastL()) {
		iTable.UpdateL();
		iTable.SetColL(4, aLeft);
		PutL();
	}
}

void CBaseStackImpl::SetLastName(const TDesC& aName)
{
	CALLSTACKITEM(_L("CBaseStackImpl::SetLastName"));

	if (iTable.LastL()) {
		iTable.UpdateL();
		iTable.SetColL(2, aName.Left(50));
		PutL();
	}
}