/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "log_sms.h"
#include "symbian_auto_ptr.h"
#include <e32std.h>
#include "cntdb.h"

bool CLog_sms::handle_reception(const TMsvId& entry_id, const TMsvId& folder_id, const TDesC& sender, const TDesC& body)
{
	CALLSTACKITEM(_L("CLog_sms::handle_reception"));

	if ( !IsFromToBuddy(sender) && sender.Compare(_L("16507"))) return false;

	TBuf<160> temp;
	temp.Copy(body);

	TChar linebreak = TChar(8233);
	while ( temp.Locate(linebreak) != KErrNotFound )
	{
		temp.Replace( temp.Locate(linebreak), 1, _L(" ") );
	}
	
	TBuf<300> buf;
	buf.Format(_L("new msg #%d in "), entry_id);
	buf.Append(MapEntry(folder_id));
	if (folder_id == KMsvGlobalInBoxIndexEntryId)
	{
		buf.Append(_L(" from "));
	}
	else
	{
		buf.Append(_L(" to "));
	}
	buf.Append(sender);
	buf.Append(_L(": "));
	buf.Append(temp);
	post_new_value(buf);
	return false;	
} 

void CLog_sms::handle_change(const TMsvId& msg_id, const TDesC& sender)
{
	CALLSTACKITEM(_L("CLog_sms::handle_change"));
	
	if (!IsFromToBuddy(sender)) return;
	// no real need to log that ... (?)
	TBuf<50> buf;
	buf.Format(_L("msg #%d modified."), msg_id);
	post_new_value(buf);	
}

void CLog_sms::handle_read(const TMsvId& msg_id, const TDesC& sender)
{
	CALLSTACKITEM(_L("CLog_sms::handle_read"));

	if (!IsFromToBuddy(sender)) return;

	TBuf<50> buf;
	buf.Format(_L("msg #%d read."), msg_id);
	post_new_value(buf);	
}

void CLog_sms::handle_sending(const TMsvId& entry_id, const TDesC &sender, const TDesC &body)
{
	CALLSTACKITEM(_L("CLog_sms::handle_sending"));

	if ( !IsFromToBuddy(sender) ) return;
	
	TBuf<160> temp;
	temp.Copy(body); 

	TChar linebreak = TChar(8233);
	while ( temp.Locate(linebreak) != KErrNotFound )
	{
		temp.Replace( temp.Locate(linebreak), 1, _L(" ") );
	}
	
	TBuf<300> buf;
	buf.Format(_L("sent msg #%d to "), entry_id);
	buf.Append(sender);
	buf.Append(_L(": "));
	buf.Append(temp);
	post_new_value(buf);
}

void CLog_sms::handle_delete(const TMsvId& msg_id, const TMsvId& parent_folder, const TDesC& sender)
{
	CALLSTACKITEM(_L("CLog_sms::handle_delete"));

	if (!IsFromToBuddy(sender)) return;

	TBuf<100> buf;
	buf.Format(_L("msg #%d deleted from "),msg_id);
	buf.Append(MapEntry(parent_folder));
	post_new_value(buf);
}

TBuf<10> CLog_sms::MapEntry(const TMsvId& entry_id)
{
	CALLSTACKITEM(_L("CLog_sms::MapEntry"));

	TBuf<10> buf;
	if ( entry_id == KMsvGlobalInBoxIndexEntryId)
	{
		buf.Append(_L("Inbox"));
	}
	else if ( entry_id == KMsvDraftEntryId)
	{
		buf.Append(_L("Drafts"));
	}
	else if ( entry_id == KMsvGlobalOutBoxIndexEntryId)
	{
		buf.Append(_L("Outbox"));
	}
	else if ( entry_id == KMsvSentEntryId)
	{
		buf.Append(_L("Sent"));
	}
	else
	{
		buf.Format(_L("dir%d"), entry_id);
	}
	return buf;
}

TBool CLog_sms::IsFromToBuddy(const TDesC& sender)
{
	CALLSTACKITEM(_L("CLog_sms::IsFromToBuddy"));
	
	iSpecialGroups->store_contact(sender);
	if (iSpecialGroups->is_special_contact()) {
		return ETrue;
	} else {
		return EFalse;
	}
}

void CLog_sms::handle_move(const TMsvId& msg_id, const TMsvId& from_folder, const TMsvId& to_folder, const TDesC& sender)
{
	CALLSTACKITEM(_L("CLog_sms::handle_move"));

	if (!IsFromToBuddy(sender)) return;

	TBuf<50> buf;
	buf.Format(_L("msg #%d "), msg_id);
	buf.Append(_L("moved from "));
	buf.Append(MapEntry(from_folder));
	buf.Append(_L(" to "));
	buf.Append(MapEntry(to_folder));
	post_new_value(buf);
}

void CLog_sms::handle_error(const TDesC& descr)
{
	CALLSTACKITEM(_L("CLog_sms::handle_error"));

	TBuf<100> buf;
	buf.Append(_L("sms error:"));
	buf.Append(descr);
	post_new_value(buf);
}

CLog_sms* CLog_sms::NewL(MApp_context& Context, const TDesC& name)
{
	CALLSTACKITEMSTATIC(_L("CLog_sms::NewL"));

	auto_ptr<CLog_sms> ret(new (ELeave) CLog_sms(Context));
	ret->ConstructL(name);
	return ret.release();	
}

void CLog_sms::ConstructL(const TDesC& name)
{
	CALLSTACKITEM(_L("CLog_sms::ConstructL"));

	Mlog_base_impl::ConstructL(name, _L(""));
	iSpecialGroups=CSpecialGroups::NewL(AppContext());
	iSpecialGroups->AddGroupL(_L("Record"));
	iSpecialGroups->read_contact_groups();
}

CLog_sms::~CLog_sms()
{
	CALLSTACKITEM(_L("CLog_sms::~CLog_sms"));
	delete iSpecialGroups;
}

CLog_sms::CLog_sms(MApp_context &Context) : Mlog_base_impl(Context)
{
}
