#include "log_systemevent.h"
#include "symbian_auto_ptr.h"
#include "checkedactive.h"

#define MAX_ERRORS	10

class CLog_SystemEventImpl : public CLog_SystemEvent, public CCheckedActive {
public:
	virtual ~CLog_SystemEventImpl();
private:
	CLog_SystemEventImpl(MApp_context& Context);
	void ConstructL(const TDesC& name, TUid Uid);
	const TDesC& get_value();

	void CheckedRunL();
	void DoCancel();

	RSystemAgent	iAgent;
	TSysAgentEvent	iEvent;
	TInt		iErrorCount;
	TBuf<20>	iVal;

	friend class CLog_SystemEvent;
};

CLog_SystemEvent* CLog_SystemEvent::NewL(MApp_context& Context, const TDesC& name, TUid Uid)
{
	auto_ptr<CLog_SystemEventImpl> ret(new (ELeave) CLog_SystemEventImpl(Context));
	ret->ConstructL(name, Uid);
	return ret.release();
}

CLog_SystemEvent::CLog_SystemEvent(MApp_context& Context) : Mlog_base_impl(Context)
{
}

CLog_SystemEventImpl::~CLog_SystemEventImpl()
{
	Cancel();
	iAgent.Close();
}

CLog_SystemEventImpl::CLog_SystemEventImpl(MApp_context& Context) : CLog_SystemEvent(Context), 
	CCheckedActive(EPriorityNormal, _L("CLog_SystemEventImpl"))
{
}

void CLog_SystemEventImpl::ConstructL(const TDesC& name, TUid Uid)
{
	Mlog_base_impl::ConstructL(name, _L(""));
	CActiveScheduler::Add(this);
	User::LeaveIfError(iAgent.Connect());

	iEvent.SetUid(Uid);
	iEvent.SetRequestStatus(iStatus);
	iAgent.NotifyOnEvent(iEvent);

	SetActive();
}

void CLog_SystemEventImpl::CheckedRunL()
{
	iVal.Zero();
	if (iStatus!=KErrNone) {
		iVal.AppendNum(iStatus.Int());
		post_new_value(iVal, Mlogger::ERR);
		iErrorCount++;
		if (iErrorCount>MAX_ERRORS) User::Leave(iStatus.Int());
	}
	iErrorCount=0;

	iVal.AppendNum(iEvent.State());
	post_new_value(iVal);
	iEvent.SetRequestStatus(iStatus);
	iAgent.NotifyOnEvent(iEvent);

	SetActive();
}

void CLog_SystemEventImpl::DoCancel()
{
	iAgent.NotifyEventCancel();
}

const TDesC& CLog_SystemEventImpl::get_value()
{
	TInt val=iAgent.GetState(iEvent.Uid());

	iVal.Zero();
	iVal.AppendNum(val);
	return iVal;
}
