#include "notifystate.h"
#include <symbian_auto_ptr.h>
#include <contextnotifyclientsession.h>
#include <gulicon.h>
#include <eikenv.h>

class CNotifyStateImpl: public CNotifyState, public MContextBase {
public:
	virtual ~CNotifyStateImpl();
private:
	CNotifyStateImpl(MApp_context& Context, const TDesC& aBitmapFilename);
	void ConstructL();

	void CheckedRunL();
	TInt CheckedRunError(TInt aError);
	void DoCancel();
	void SetCurrentState(TInt aIconId, TInt aMaskId);
	void StartL();
	void SetIcon();
	void Release();

	TFileName	iFilename;
	TInt		iNotifyId;

	enum TRunState { EIdle, EChanging };
	TRunState iRunState;
	TInt	iNextIconId, iNextMaskId;
	CGulIcon	*iIcon;
	RContextNotifyClientSession iNotifyClient;

	friend class CNotifyState;
};

CNotifyState* CNotifyState::NewL(MApp_context& Context, const TDesC& aBitmapFilename)
{
	auto_ptr<CNotifyStateImpl> ret(new (ELeave) CNotifyStateImpl(Context, aBitmapFilename));
	ret->ConstructL();
	return ret.release();
}

CNotifyState::CNotifyState() : CCheckedActive(EPriorityNormal, _L("CNotifyStateImpl"))
{
}

CNotifyState::~CNotifyState()
{
}

CNotifyStateImpl::CNotifyStateImpl(MApp_context& Context, const TDesC& aBitmapFilename) : 
	MContextBase(Context), iFilename(aBitmapFilename), iNotifyId(-1), iNextIconId(-1)
{
}

void CNotifyStateImpl::Release()
{
	Cancel();
	iNotifyClient.Close();
	iNotifyId=-1;
	delete iIcon; iIcon=0;
}

CNotifyStateImpl::~CNotifyStateImpl()
{
	Release();
}

void CNotifyStateImpl::ConstructL()
{
	CActiveScheduler::Add(this);
	StartL();
}

void CNotifyStateImpl::StartL()
{
	User::LeaveIfError( iNotifyClient.Connect() );
}

void CNotifyStateImpl::CheckedRunL()
{
	iRunState=EIdle;
	if (iStatus!=KErrNone) 
		User::Leave(iStatus.Int());
}

TInt CNotifyStateImpl::CheckedRunError(TInt aError)
{
	Release();
	TRAPD(err, StartL());
	if (err==KErrNone) {
		SetIcon();
	}
	return err;
}

void CNotifyStateImpl::DoCancel()
{
	iNotifyClient.Cancel();
}

void CNotifyStateImpl::SetCurrentState(TInt aIconId, TInt aMaskId)
{
	iNextIconId=aIconId; iNextMaskId=aMaskId;
	if (iRunState==EIdle) {
		SetIcon();
	}
}

void CNotifyStateImpl::SetIcon()
{
	delete iIcon; iIcon=0;

	iIcon=CEikonEnv::Static()->CreateIconL(iFilename, iNextIconId, iNextMaskId);

	iStatus=KRequestPending;
	if (iNotifyId>=0) {
		iNotifyClient.ChangeIcon(iIcon->Bitmap(), iIcon->Mask(), iNotifyId, iStatus);
	} else {
		iNotifyClient.AddIcon(iIcon->Bitmap(), iIcon->Mask(), iNotifyId, iStatus);
	}
	iRunState=EChanging;
	SetActive();
}