#include "sms_snapshot.h"
#include "camera.h"
#include "mms.h"
#include <list.h>
#include <symbian_auto_ptr.h>
#include "cl_settings.h"
#include "transfer.h"
#include "uploadview.h"
#include <timeout.h>
#include <aknsoundsystem.h> 
#include <context_log.rsg>

//#define TESTING 1

class TNoUploadPrompt : public MUploadPrompt {
	void Prompt(const TDesC& /*FileName*/, MUploadCallBack* CallBack);
};

void TNoUploadPrompt::Prompt(const TDesC& /*FileName*/, MUploadCallBack* CallBack)
{
	CallBack->Back(false, true, 0);
}

class CSmsSnapshotImpl : public CSmsSnapshot, public MContextBase, public MSnapShotNofifier, public MSettingListener,
	public MTimeOut {
private:
	CSmsSnapshotImpl(MApp_context& Context, i_status_notif* cb, MPresenceData* Presence);
	void ConstructL();

	virtual void Test();

	//from i_handle_received_sms
	virtual bool handle_reception(const TMsvId& entry_id, const TMsvId& folder_id, const TDesC& sender, const TDesC& body); // return true if message is to be deleted
	virtual void handle_change(const TMsvId& , const TDesC& ) { }
	virtual void handle_delete(const TMsvId& , const TMsvId& , const TDesC& ) { }
	virtual void handle_move(const TMsvId& , const TMsvId& , const TMsvId& , const TDesC& ) { }
	virtual void handle_error(const TDesC& ) { }
	virtual void handle_sending(const TMsvId& , const TDesC& , const TDesC& ) { }
	virtual void handle_read (const TMsvId& , const TDesC& ) { }

	// from MSnapShotNofifier
	virtual void Error(TInt aCode, const TDesC& aDescription);
	virtual void Taken(const TDesC& aFileName);
	virtual void Info(const TDesC& aMsg);

	// from MSettingListener
	virtual void SettingChanged(TInt Setting);

	// from MTimeOut
	virtual void expired(CBase* Source);

	struct TSendTo {
		TBuf<20>	iTo;
		TBuf<150>	iBody;
		TSendTo(const TDesC& To, const TDesC& Body) {
			iTo=To.Left(20);
			iBody=Body.Left(150);
		}
		TSendTo() : iTo(), iBody() { }
	};

	CList<TSendTo>*	iToBeSend;
	CSnapShot*	iSnapShot;
	CMMS*		iMMS;
	TBool		iEnabled;
	i_status_notif*	cb;
	MPresenceData*  iPresence;
	CFtpTransfer*	iTransfer;
	TNoUploadPrompt	iDummyPrompt;
	CTimeOut*	iTimer;
	CAknKeySoundSystem* iSoundSystem;
	TInt		iRetryCount;
	bool		iDeleting;

	friend class CSmsSnapshot;

public:
	~CSmsSnapshotImpl();
};

CSmsSnapshotImpl::~CSmsSnapshotImpl()
{
	iDeleting=true;

	Settings().CancelNotifyOnChange(SETTING_SNAPSHOT_ON_SMS, this);
	delete iMMS;
	delete iToBeSend;
	delete iSnapShot;
	delete iTransfer;
	delete iTimer;
}

CSmsSnapshot* CSmsSnapshot::NewL(MApp_context& Context, i_status_notif* cb, MPresenceData* Presence)
{
	CALLSTACKITEM2(_L("CSmsSnapshot::NewL"), &Context);

	auto_ptr<CSmsSnapshotImpl> ret(new (ELeave) CSmsSnapshotImpl(Context, cb, Presence));
	ret->ConstructL();
	return ret.release();
}

CSmsSnapshotImpl::CSmsSnapshotImpl(MApp_context& Context, i_status_notif* i_cb, MPresenceData* Presence) : 
		MContextBase(Context), cb(i_cb), iPresence(Presence)
{
	CALLSTACKITEM(_L("CSmsSnapshotImpl::CSmsSnapshotImpl"));

}

CSmsSnapshot::~CSmsSnapshot() { }

void CSmsSnapshotImpl::ConstructL()
{
	CALLSTACKITEM(_L("CSmsSnapshotImpl::ConstructL"));

	iSoundSystem = (STATIC_CAST(CAknAppUi*,
			      CEikonEnv::Static()->AppUi()))->KeySounds();
	TRAPD(error, iSoundSystem->AddAppSoundInfoListL( R_CAMERA_SNAP_SOUND ));

	iToBeSend=CList<TSendTo>::NewL();
	iTimer=CTimeOut::NewL(*this);
	iEnabled=EFalse;
	Settings().GetSettingL(SETTING_SNAPSHOT_ON_SMS, iEnabled);
	if (iEnabled) {
		iSnapShot=CSnapShot::NewL(AppContext());
		iTimer->Wait(5*60);
	}
	Settings().NotifyOnChange(SETTING_SNAPSHOT_ON_SMS, this);
	iMMS=CMMS::NewL();
	iTransfer=CFtpTransfer::NewL(AppContext(), cb, DataDir(), _L(""), CFtpTransfer::HTTP,
		iDummyPrompt, false);
	iTransfer->add_filesL(_L("SnapShot*jpg"), false);
}

void CSmsSnapshotImpl::Test()
{
	handle_reception(TMsvId(1), TMsvId(1), _L("0505536758"), _L("testing"));
}

bool CSmsSnapshotImpl::handle_reception(const TMsvId& , const TMsvId& , const TDesC& sender, const TDesC& body)
{
	CALLSTACKITEM(_L("CSmsSnapshotImpl::handle_reception"));

	 // return true if message is to be deleted
	if (!iEnabled) return false;
	if (sender.Length()<4) return false;
	iToBeSend->AppendL(TSendTo(sender, body));

	cb->status_change(_L("taking picture"));
	iSnapShot->TakeSnapShot(DataDir(), this);

	return true;
}

void CSmsSnapshotImpl::Error(TInt aCode, const TDesC& aDescription)
{
	CALLSTACKITEM(_L("CSmsSnapshotImpl::Error"));

	if (iDeleting) return;

	iRetryCount++;
	if (iRetryCount<=5) {
		iSnapShot->TakeSnapShot(DataDir(), this);
		cb->status_change(_L("retrying snapshot"));
		return;
	}

	TSendTo t=iToBeSend->Pop();
	HBufC* b=HBufC::NewLC(aDescription.Length()+30+t.iBody.Length());
	b->Des().Append(_L("Failed to take picture: "));
	b->Des().Append(aDescription);
	b->Des().Append(_L(" for "));
	b->Des().Append(t.iBody);
#ifndef TESTING
	iMMS->SendMessage(t.iTo, *b, _L(""), t.iBody, false);
#endif

	b->Des().Zero();
	b->Des().Append(aDescription);
	b->Des().Append(_L(": "));
	b->Des().AppendNum(aCode);
	cb->error(*b);
	CleanupStack::PopAndDestroy();
}

void CSmsSnapshotImpl::Taken(const TDesC& aFileName)
{
	CALLSTACKITEM(_L("CSmsSnapshotImpl::Taken"));

	iSoundSystem->PlaySound(1);

	iRetryCount=0;

	TSendTo t=iToBeSend->Pop();
#ifndef TESTING
	HBufC* b=HBufC::NewLC(t.iBody.Length()+t.iTo.Length()+10);
	b->Des().Append(t.iBody);
	cb->status_change(_L("sending MMS"));
	iMMS->SendMessage(t.iTo, *b, aFileName, t.iBody, false);
	b->Des().Append(_L(" from "));
	b->Des().Append(t.iTo);

	CXmlBuf* buf=CUploadView::MakePacketL(_L("SMS"), *b,
		AppContext(), iPresence, 0);
	CleanupStack::PopAndDestroy(); // b
	CleanupStack::PushL(buf);
	iTransfer->PutIntoFilesL(true, true, buf, aFileName);
	CleanupStack::PopAndDestroy(buf);
#else
	iTransfer->PutIntoFilesL(false, true, 0, aFileName);
#endif

	iTimer->Wait(150);
}

void CSmsSnapshotImpl::Info(const TDesC& aMsg)
{
	CALLSTACKITEM(_L("CSmsSnapshotImpl::Info"));

	cb->status_change(aMsg);
}

// from MSettingListener
void CSmsSnapshotImpl::SettingChanged(TInt /*Setting*/)
{
	CALLSTACKITEM(_L("CSmsSnapshotImpl::SettingChanged"));

	Settings().GetSettingL(SETTING_SNAPSHOT_ON_SMS, iEnabled);
	if (iEnabled) {
		iTimer->Wait(5*60);
		if (!iSnapShot) iSnapShot=CSnapShot::NewL(AppContext());
		cb->status_change(_L("enabling sms snapshot"));
	} else {
		iTimer->Reset();
		delete iSnapShot; iSnapShot=0;
		cb->status_change(_L("disabling sms snapshot"));
	}
}

void CSmsSnapshotImpl::expired(CBase* /*Source*/)
{
	TBuf<50> url;
	Settings().GetSettingL(SETTING_PUBLISH_URLBASE, url);

	TTime now(0);

	iTransfer->TransferFiles(_L("SMS"), now, url);

	iTimer->Wait(5*60);
}