/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#include "statusview.h"

// INCLUDE FILES
#include  <aknviewappui.h>
#include  <avkon.hrh>
#include  <context_log.rsg>
#include  "StatusView.h"
#include  "context_logContainer.h" 
#include  "Context_log.hrh"
#include  "symbian_auto_ptr.h"

// ---------------------------------------------------------
// CStatusView::ConstructL(const TRect& aRect)
// EPOC two-phased constructor
// ---------------------------------------------------------
//

CStatusView* CStatusView::NewL(MApp_context& Context, CCellMap& CellMap)
{
	CALLSTACKITEM2(_L("CStatusView::NewL"), &Context);

	auto_ptr<CStatusView> ret(new (ELeave) CStatusView(Context));
	ret->ConstructL(CellMap);
	return ret.release();
}

void CStatusView::ConstructL(CCellMap& CellMap)
{
	CALLSTACKITEM(_L("CStatusView::ConstructL"));

	BaseConstructL( R_CL_STATUSVIEW );
	iContainer = new (ELeave) CContext_logContainer(AppContext(), CellMap);
	iContainer->MakeVisible(EFalse);
	iContainer->SetMopParent(this);
	iContainer->ConstructL( ClientRect() );
}

// ---------------------------------------------------------
// CStatusView::~CStatusView()
// ?implementation_description
// ---------------------------------------------------------
//
CStatusView::~CStatusView()
{
	CALLSTACKITEM(_L("CStatusView::~CStatusView"));

	if ( iContainer && iActive )
        {
		AppUi()->RemoveFromViewStack( *this, iContainer );
        }
	
	delete iContainer;
}

// ---------------------------------------------------------
// TUid CStatusView::Id()
// ?implementation_description
// ---------------------------------------------------------
//
TUid CStatusView::Id() const
{
	CALLSTACKITEM(_L("CStatusView::Id"));

	return KStatusViewId;
}

// ---------------------------------------------------------
// CStatusView::HandleCommandL(TInt aCommand)
// ?implementation_description
// ---------------------------------------------------------
//
void CStatusView::HandleCommandL(TInt aCommand)
{   
	CALLSTACKITEM(_L("CStatusView::HandleCommandL"));

	AppUi()->HandleCommandL(aCommand);
}

// ---------------------------------------------------------
// CStatusView::HandleClientRectChange()
// ---------------------------------------------------------
//
void CStatusView::HandleClientRectChange()
{
	CALLSTACKITEM(_L("CStatusView::HandleClientRectChange"));

	if ( iContainer )
        {
		iContainer->SetRect( ClientRect() );
        }
}

// ---------------------------------------------------------
// CStatusView::DoActivateL(...)
// ?implementation_description
// ---------------------------------------------------------
//
void CStatusView::DoActivateL(
				   const TVwsViewId& /*aPrevViewId*/,TUid /*aCustomMessageId*/,
				   const TDesC8& /*aCustomMessage*/)
{
	CALLSTACKITEM(_L("CStatusView::DoActivateL"));

	iActive=true;
	iContainer->MakeVisible(ETrue);
	AppUi()->AddToStackL( *this, iContainer );

	if (iNextViewId != TVwsViewId()) {
		TRAPD(err, ActivateViewL(iNextViewId));
		iNextViewId= TVwsViewId();
	}
}

// ---------------------------------------------------------
// CStatusView::HandleCommandL(TInt aCommand)
// ?implementation_description
// ---------------------------------------------------------
//
void CStatusView::DoDeactivate()
{
	CALLSTACKITEM(_L("CStatusView::DoDeactivate"));

	iActive=false;
	AppUi()->RemoveFromViewStack( *this, iContainer );
	iContainer->MakeVisible(EFalse);
}

void CStatusView::DynInitMenuPaneL(
		 TInt aResourceId,CEikMenuPane* aMenuPane)
{
	CALLSTACKITEM(_L("CStatusView::DynInitMenuPaneL"));

	AppUi()->DynInitMenuPaneL(aResourceId, aMenuPane);
}

// End of File


