/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CONTEXTBOOKAPPUI_H
#define CONTEXTBOOKAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknviewappui.h>
#include <akntabgrp.h>
#include <aknnavide.h>
#include <akniconarray.h>
#include "contextbookview.h"
#include "file_output_base.h"

// FORWARD DECLARATIONS
class CContextbookContainer;

#include "app_context.h"
#include "phonebook.h"
#include "call_log.h"
#include "jabberdata.h"
#include "cb_presence.h"
#include "presencedetailview.h"

// CONSTANTS
//const ?type ?constant_var = ?constant;


// CLASS DECLARATION

/**
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
* - view architecture
* - status pane
* 
*/
class CContextbookAppUi : public CAknViewAppUi, MCoeForegroundObserver, public MContextBase, public MPresenceListener
    {
    public: // // Constructors and destructor
	    CContextbookAppUi (MApp_context& Context) : MContextBase(Context) { }

        /**
        * EPOC default constructor.
        */      
        void ConstructL();

        /**
        * Destructor.
        */      
        ~CContextbookAppUi();
        
    public: // New functions
	void Notify(const TDesC& aMessage);
	void PresenceChangedL(TInt ContactId, MPresenceData& Info);
	void DisplayPresenceDetailsL(const TDesC& Name, const MPresenceData* PresenceData);
    public: // Functions from base classes

    private:
        // From MEikMenuObserver
        void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);

    private:
        /**
        * From CEikAppUi, takes care of command handling.
        * @param aCommand command to be handled
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From CEikAppUi, handles key events.
        * @param aKeyEvent Event to handled.
        * @param aType Type of the key event. 
        * @return Response code (EKeyWasConsumed, EKeyWasNotConsumed). 
        */
        virtual TKeyResponse HandleKeyEventL(
            const TKeyEvent& aKeyEvent,TEventCode aType);

	void hide();
	virtual void HandleGainingForeground();
	virtual void HandleLosingForeground();
	void ShowEditor(bool existing);
	
    private: //Data
	phonebook*	book;
	CDb*		iJabberDb;
	CJabberData*	iJabberData;
	call_log*	log;
	CContextbookView* view1;
	CContextbookView* view2;
	HBufC		*iCaptionLog, *iCaptionBook;
	
	CPresenceUpdater* iPresenceUpdater;
	CPresenceHolder* iPresenceHolder;

	Cfile_output_base * iLog;

	CAknIconArray * iconlist;

	
	CPresenceDetailView	*iPresenceDetailView; // OWNED BY FRAMEWORK
    };

#endif

// End of File
