/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CB_CALL_LOG_H_INCLUDED
#define CB_CALL_LOG_H_INCLUDED

#include "phonebook.h"
#include <logview.h>
#include <logcli.h>
#include "symbian_tree.h"



class call_log: public phonebook_i, public CCheckedActive {
public:
	call_log();
	virtual ~call_log();
	void ConstructL();
	
	MDesCArray* get_array();
	bool filter(const TDesC& substr, bool force=false);
	TPtrC get_phone_no(TInt index);
	virtual void set_observer(phonebook_observer* i_obs);
	virtual CPbkContactEngine* get_engine() { return eng; }
	virtual TInt GetContactId(TInt /*Index*/) { return KErrNotFound; }
	virtual TInt GetIndex(TInt /*ContactId*/) { return KErrNotFound; }
	virtual contact * GetContact(TInt /*contactId*/) { return NULL; }
	
	void CheckedRunL();
	void DoCancel();

	void refresh();
private:
	bool handle_event(const CLogEvent& ev);
	void copy_new_to_current();
	void ReRead();
private:	
	enum state { IDLE, WAITING_SET, WAITING_NEXT };
	state current_state;
	CPbkContactEngine *eng;
	bool owns_engine;
	phonebook_observer* obs;
	CPtrCArray* current_array;
	CPtrCArray* current_nos;

	CLogViewRecent* recent;
	CLogClient* logclient;
	CLogFilter* logfilter;

	CDesCArray* all_array;
	CDesCArray* all_nos;
	TLogId last_seen_id;
	bool getting_first;
	TInt new_from;
	CGenericIntMap* iContactToItems;

	bool do_refresh; // redo refresh after current

};

#endif
