/* 
    Copyright (C) 2004  Mika Raento - Renaud Petit

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    email: mraento@cs.helsinki.fi - petit@cs.helsinki.fi 
*/


#ifndef CB_NICKFORM_H_INCLUDED
#define CB_NICKFORM_H_INCLUDED 1

#include "app_context.h"
#include <aknform.h>
#include "jabberdata.h"
#include "phonebook.h"

class CNickForm : public CAknForm
{
public:
        static CNickForm* NewL(CJabberData& Data, TInt ContactId, const TDesC& Title, phonebook_i* Book);
	
        virtual ~CNickForm();
	
        TInt ExecuteLD(); 
        void PrepareLC(); 
	
private:  // Constructor
        CNickForm(CJabberData& Data, TInt ContactId, phonebook_i* Book);
        void ConstructL(const TDesC& Title);
	
private:  // Functions from base class
	void SetInitialCurrentLine();
        void PostLayoutDynInitL();
        TBool QuerySaveChangesL();
        TBool SaveFormDataL(); 
        void DoNotSaveFormDataL();
	virtual TBool OkToExitL( TInt aButtonId ) ;

	CJabberData&	iData;
	TBuf<50>	iNick;
	TInt		iContactId;
	HBufC*		iTitle;
	phonebook_i*	iBook;

};

#endif
