#!/usr/bin/perl

$file=$ARGV[0];
$version=$ARGV[1];
open(INV, "<$version") || die "cannot open version file";
while(<INV>) {
	chop;
	($t, $v)=split(/\s*=\s*/);
	$versions{lc($t)}=$v;
}
close(INV);
die "no minor version specified" if ($versions{'minor'} eq "");
die "no major version specified" if ($versions{'major'} eq "");

open(OUT, ">${file}.tmp") || die "cannot open output";
open(IN, "<$file") || die "cannot open input";

while(<IN>) {
	if (/^#/) {
		/(.*, *)([0-9]+), *([0-9]+)( *,[0-9]+\s*)$/;
		($beg,$major,$minor,$rest)=($1,$2,$3,$4);
		$minor=$versions{'minor'};
		$major=$versions{'major'};
		print OUT $beg, $major, ",", $minor, $rest;
	} else {
		print OUT $_;
	}
}

close(IN);
close(OUT);

system("move ${file}.tmp $file");
