/*
 * Decompiled with CFR 0.152.
 */
package maito.browsing;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import maito.resource.Resource;
import maito.resource.ResourceLoader;
import maito.resource.ResourceRelation;
import maito.util.DbTools;
import maito.util.Tools;

public class DatabaseManager {
    private Connection connection;
    private Properties config = Tools.loadProperties(Tools.PATH_DBCONFIG);
    private String[] graphs;
    private String currentGraph;
    private ResourceLoader loader;
    private String latestQuery;

    protected DatabaseManager() throws SQLException {
        if (this.config == null) {
            throw new SQLException("Could not load database configuration file");
        }
        this.connection = DbTools.createDbConnection(this.config);
        this.connection.setAutoCommit(true);
        this.graphs = this.getGraphDbNames();
        this.loader = new ResourceLoader(this.connection);
        this.latestQuery = null;
    }

    protected void executeSQL(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            return;
        }
        if ((string = string.trim()).endsWith(";")) {
            string = new StringBuffer(string).deleteCharAt(string.lastIndexOf(";")).toString();
        }
        this.currentGraph = string2;
        Statement statement = this.connection.createStatement();
        statement.execute("use " + string2 + ";");
        boolean bl = string.startsWith("select");
        if (bl) {
            this.latestQuery = string;
            this.loader.executeSQL(string);
        } else {
            this.latestQuery = null;
            statement.execute(string);
        }
    }

    protected void executeLatestQuery() throws SQLException {
        if (this.latestQuery != null) {
            this.loader.executeSQL(this.latestQuery);
        }
    }

    protected Resource nextResource() throws SQLException {
        return this.loader.nextResource();
    }

    protected String[] getGraphs() {
        return this.graphs;
    }

    protected ResourceRelation[] getRelations(Resource resource) throws SQLException {
        ResourceRelation[] resourceRelationArray;
        String string = resource.getID();
        string = string.replaceAll("'", "''");
        Vector<ResourceRelation[]> vector = new Vector<ResourceRelation[]>();
        Statement statement = this.connection.createStatement();
        statement.execute("use " + this.currentGraph);
        ResultSet resultSet = statement.executeQuery("select * from ResourceRelation where subject = '" + string + "';");
        while (resultSet.next()) {
            resourceRelationArray = new ResourceRelation();
            resourceRelationArray.setSubject(resultSet.getString("subject"));
            resourceRelationArray.setObject(resultSet.getString("object"));
            resourceRelationArray.setRole(resultSet.getString("role"));
            vector.add(resourceRelationArray);
        }
        resourceRelationArray = null;
        if (vector.size() > 0) {
            resourceRelationArray = new ResourceRelation[vector.size()];
            resourceRelationArray = vector.toArray(resourceRelationArray);
        }
        return resourceRelationArray;
    }

    private String[] getGraphDbNames() {
        String[] stringArray = new String[]{};
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("show databases;");
            Vector<String> vector = new Vector<String>();
            String string = this.config.getProperty("dbname_resources");
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (!string2.startsWith(string)) continue;
                vector.add(string2);
            }
            resultSet.close();
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.get(i);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringArray;
    }
}

