/*
 * Decompiled with CFR 0.152.
 */
package maito.browsing;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import maito.browsing.DatabaseManager;
import maito.browsing.fileexport.FileExporter;
import maito.browsing.fileexport.FileExporterImpl;
import maito.resource.Resource;
import maito.resource.ResourceRelation;

public class ResourceBrowser {
    private HashMap relations;
    private DatabaseManager dbManager;
    private FileExporter exporter;

    public ResourceBrowser() throws RuntimeException {
        try {
            this.dbManager = new DatabaseManager();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("cannot connect to database");
        }
        this.relations = new HashMap();
        this.exporter = new FileExporterImpl();
    }

    public String[] getGraphs() {
        return this.dbManager.getGraphs();
    }

    public Resource nextResource() throws SQLException {
        return this.dbManager.nextResource();
    }

    public String[] getFileFormats() {
        return this.exporter.getFormats();
    }

    public void executeSQL(String string, String string2) throws SQLException {
        this.dbManager.executeSQL(string, string2);
    }

    public boolean writeToFile(String string, String string2) {
        boolean bl = false;
        try {
            Object[] objectArray;
            this.dbManager.executeLatestQuery();
            Vector<Resource> vector = new Vector<Resource>();
            Resource resource = this.dbManager.nextResource();
            while (resource != null) {
                vector.add(resource);
                objectArray = this.dbManager.getRelations(resource);
                if (objectArray != null) {
                    this.relations.put(resource.getID(), objectArray);
                }
                resource = this.dbManager.nextResource();
            }
            objectArray = new Resource[vector.size()];
            objectArray = vector.toArray(objectArray);
            bl = this.exporter.writeFile(string, string2, (Resource[])objectArray, this.getRelations());
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    private ResourceRelation[] getRelations() {
        Vector vector = new Vector(this.relations.values());
        Vector<ResourceRelation> vector2 = new Vector<ResourceRelation>();
        for (int i = 0; i < vector.size(); ++i) {
            ResourceRelation[] resourceRelationArray = (ResourceRelation[])vector.get(i);
            for (int j = 0; j < resourceRelationArray.length; ++j) {
                vector2.add(resourceRelationArray[j]);
            }
        }
        Object[] objectArray = new ResourceRelation[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public static void main(String[] stringArray) {
    }
}

