/*
 * Decompiled with CFR 0.152.
 */
package maito.browsing.fileexport;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import maito.browsing.fileexport.FileFormat;
import maito.resource.Resource;
import maito.resource.ResourceRelation;
import maito.util.Tools;

public class CSVResourceListFormat
implements FileFormat {
    private boolean includeID = false;
    private boolean includeKeyWords = false;
    private boolean includeExtIDs = false;
    private String[] singleFields;
    private final String EXPORTFIELDCONFIG_PATH = "config" + File.separator + "csvlistexport.properties";
    private Properties exportFieldMap = Tools.loadProperties(this.EXPORTFIELDCONFIG_PATH);
    private Resource[] resources = null;
    private ResourceRelation[] relations = null;
    private boolean append = false;

    public CSVResourceListFormat() {
        if (this.exportFieldMap == null) {
            System.out.println("ERROR: Could not load csvlistexport.properties");
        }
    }

    public void setResources(Resource[] resourceArray) {
        this.resources = resourceArray;
    }

    public void setRelations(ResourceRelation[] resourceRelationArray) {
        this.relations = resourceRelationArray;
    }

    public boolean writeFile(String string) {
        int n;
        String string2;
        String string3 = null;
        String string4 = null;
        if (this.exportFieldMap == null) {
            return false;
        }
        if (this.exportFieldMap.getProperty("includeID").trim().equals("1")) {
            this.includeID = true;
        }
        if (this.exportFieldMap.getProperty("includeKeyWords").trim().equals("1")) {
            this.includeKeyWords = true;
        }
        if (this.exportFieldMap.getProperty("includeExtIDs").trim().equals("1")) {
            this.includeExtIDs = true;
        }
        if ((string2 = this.exportFieldMap.getProperty("singleFields")) != null) {
            this.singleFields = string2.split(",");
            for (n = 0; n < this.singleFields.length; ++n) {
                this.singleFields[n] = this.singleFields[n].trim();
            }
        }
        if (this.resources != null && this.relations != null) {
            string3 = string + "-resources";
            string4 = string + "-relations";
            n = string.lastIndexOf(".");
            if (n != -1) {
                string3 = string.substring(0, n) + "-resources." + string.substring(n + 1, string.length());
                string4 = string.substring(0, n) + "-relations." + string.substring(n + 1, string.length());
            }
        } else if (this.resources != null) {
            string3 = string;
        } else if (this.relations != null) {
            string4 = string;
        } else {
            return false;
        }
        if (string3 != null && (n = (int)(this.saveResources(string3) ? 1 : 0)) == 0) {
            return false;
        }
        return string4 == null || (n = (int)(this.saveRelations(string4) ? 1 : 0)) != 0;
    }

    private boolean saveResources(String string) {
        boolean bl = false;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, this.append), "UTF-8"));
            if (this.includeID) {
                bufferedWriter.write("\"Resource id\"");
                bl = true;
            }
            if (this.includeKeyWords) {
                if (bl) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write("\"KeyWords\"");
                bl = true;
            }
            if (this.includeExtIDs) {
                if (bl) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write("\"ExtIDs\"");
                bl = true;
            }
            for (int i = 0; i < this.singleFields.length; ++i) {
                if (bl) {
                    bufferedWriter.write(",");
                }
                bufferedWriter.write("\"" + this.singleFields[i] + "\"");
                bl = true;
            }
            bufferedWriter.write("\n");
            bl = false;
            for (int i = 0; i < this.resources.length; ++i) {
                String string2;
                String string3;
                Iterator iterator;
                if (this.includeID) {
                    bufferedWriter.write("\"" + this.resources[i].getID() + "\"");
                    bl = true;
                }
                if (this.includeKeyWords) {
                    if (bl) {
                        bufferedWriter.write(",");
                    }
                    HashSet hashSet = this.resources[i].getKeywords();
                    iterator = hashSet.iterator();
                    string3 = "";
                    while (iterator.hasNext()) {
                        string2 = (String)iterator.next();
                        string2 = string2.replaceAll("\"", "\"\"");
                        string3 = string3 + ", " + string2;
                    }
                    bufferedWriter.write("\"" + string3 + "\"");
                    bl = true;
                }
                if (this.includeExtIDs) {
                    if (bl) {
                        bufferedWriter.write(",");
                    }
                    HashSet hashSet = this.resources[i].getExtIDs();
                    iterator = hashSet.iterator();
                    string3 = "";
                    while (iterator.hasNext()) {
                        string2 = (String)iterator.next();
                        string2 = string2.replaceAll("\"", "\"\"");
                        string3 = string3 + ", " + string2;
                    }
                    bufferedWriter.write("\"" + string3 + "\"");
                    bl = true;
                }
                for (int j = 0; j < this.singleFields.length; ++j) {
                    if (bl) {
                        bufferedWriter.write(",");
                    }
                    if ((string3 = this.resources[i].getSingleField(this.singleFields[j])) != null) {
                        string3 = string3.replaceAll("\"", "\"\"");
                        bufferedWriter.write("\"" + string3 + "\"");
                    }
                    bl = true;
                }
                bufferedWriter.write("\n");
                bl = false;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("ERROR in CSVResourceListFormat.saveResources: " + exception);
            return false;
        }
        return true;
    }

    private boolean saveRelations(String string) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, this.append), "UTF-8"));
            bufferedWriter.write("Subject,Role,Object\n");
            for (int i = 0; i < this.relations.length; ++i) {
                String string2 = this.relations[i].getSubject();
                String string3 = this.relations[i].getRole();
                String string4 = this.relations[i].getObject();
                string2 = string2 == null ? "" : "\"" + string2.replaceAll("\"", "\"\"") + "\"";
                string3 = string3 == null ? "" : "\"" + string3.replaceAll("\"", "\"\"") + "\"";
                string4 = string4 == null ? "" : "\"" + string4.replaceAll("\"", "\"\"") + "\"";
                bufferedWriter.write(string2 + "," + string3 + "," + string4 + "\n");
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("ERROR in CSVResourceListFormat.saveRelations: " + exception);
            return false;
        }
        return true;
    }
}

