/*
 * Decompiled with CFR 0.152.
 */
package maito.browsing.fileexport;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import maito.browsing.fileexport.FileExporter;
import maito.browsing.fileexport.FileFormat;
import maito.resource.Resource;
import maito.resource.ResourceRelation;
import maito.util.Tools;

public class FileExporterImpl
implements FileExporter {
    private final String FORMATCONFIG_PATH = "config" + File.separator + "exportformats.properties";
    private String fileFormatClass;
    private Properties formatMap = Tools.loadProperties(this.FORMATCONFIG_PATH);

    public FileExporterImpl() {
        if (this.formatMap == null) {
            System.out.println("ERROR: Could not load exportformats.properties");
        }
    }

    public boolean writeFile(String string, String string2, Resource[] resourceArray, ResourceRelation[] resourceRelationArray) {
        this.fileFormatClass = this.formatMap.getProperty(string2);
        if (this.fileFormatClass == null) {
            return false;
        }
        FileFormat fileFormat = null;
        try {
            fileFormat = (FileFormat)Class.forName(this.fileFormatClass).newInstance();
        }
        catch (Exception exception) {
            System.out.println("Error in FileExporterImpl.writeFile: " + exception);
            return false;
        }
        fileFormat.setResources(resourceArray);
        fileFormat.setRelations(resourceRelationArray);
        boolean bl = fileFormat.writeFile(string);
        return bl;
    }

    public String[] getFormats() {
        if (this.formatMap == null) {
            return null;
        }
        Enumeration<?> enumeration = this.formatMap.propertyNames();
        String[] stringArray = new String[this.formatMap.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)enumeration.nextElement();
        }
        return stringArray;
    }
}

