/*
 * Decompiled with CFR 0.152.
 */
package maito.browsing.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import maito.browsing.ResourceBrowser;
import maito.resource.Resource;
import maito.util.XMLTools;

public class MainWindow
extends JFrame
implements Runnable {
    private JPanel resourceGraphPanel;
    private JPanel sqlPanel;
    private JPanel fixedQueryPanel;
    private JPanel queryPanel;
    private JPanel resourcePanel;
    private TitledBorder resourcePanelBorder;
    private JPanel exportPanel;
    private JPanel fileFormatPanel;
    private JPanel pageSelectorPanel;
    private JTextArea queryArea;
    private JScrollPane queryScrollPanel;
    private JEditorPane documentsHTMLPanel;
    private JScrollPane documentsPanel;
    private JEditorPane actorsHTMLPanel;
    private JScrollPane actorsPanel;
    private JEditorPane channelsHTMLPanel;
    private JScrollPane channelsPanel;
    private JEditorPane rolesHTMLPanel;
    private JScrollPane rolesPanel;
    private JButton queryProcessButton;
    private JButton saveFileButton;
    private JButton nextPageButton;
    private JButton previousPageButton;
    private JComboBox graphSelectCombo;
    private JComboBox fixedQueryCombo;
    private JComboBox fileFormatCombo;
    private JLabel graphSelectLabel;
    private JLabel fixedQueryLabel;
    private JLabel fileFormatLabel;
    private JFileChooser fileChooser;
    private ResourceBrowser browser = new ResourceBrowser();
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private File exampleQueriesFile;
    private String[] exampleQueries;
    private String[] exampleQueryNames;
    private final int WINDOW_WIDTH = 800;
    private final int WINDOW_HEIGHT = 600;
    private final String EXAMPLEQUERIES_PATH = "config";
    private final String EXAMPLEQUERIES_FILE = "queries.xml";
    private boolean updatingView;
    private final String RESOURCE_PANEL_TITLE_NORMAL = "Resources";
    private final String RESOURCE_PANEL_TITLE_PROCESSING = "Fetching resources...";
    private final String RESOURCE_PANEL_TITLE_FORMINGVIEW = "Forming resource views...";
    private final int PAGE_SIZE = 200;
    private int currentPage;
    private int pageCount;
    private Vector documentsPages;
    private Vector actorsPages;
    private Vector channelsPages;
    private Vector rolesPages;

    public MainWindow() {
        this.getExampleQueries();
        this.initComponents();
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.updatingView = false;
        this.documentsPages = new Vector();
        this.actorsPages = new Vector();
        this.channelsPages = new Vector();
        this.rolesPages = new Vector();
        this.currentPage = 0;
        this.pageCount = 0;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.setDefaultCloseOperation(3);
        this.setTitle("Resource Browser");
        this.resourceGraphPanel = new JPanel();
        this.resourceGraphPanel.setLayout(new BoxLayout(this.resourceGraphPanel, 0));
        this.resourceGraphPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.graphSelectLabel = new JLabel();
        this.graphSelectLabel.setHorizontalAlignment(2);
        this.graphSelectLabel.setText("Select Resource Graph:");
        String[] stringArray = this.browser.getGraphs();
        if (stringArray == null) {
            JOptionPane.showMessageDialog(this, "Could not find resource graphs", "Configuration Error", 0);
        }
        this.graphSelectCombo = new JComboBox<String>(stringArray);
        this.resourceGraphPanel.add(this.graphSelectLabel);
        this.resourceGraphPanel.add(Box.createRigidArea(new Dimension(3, 0)));
        this.resourceGraphPanel.add(this.graphSelectCombo);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.resourceGraphPanel, gridBagConstraints);
        this.sqlPanel = new JPanel();
        this.sqlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        this.sqlPanel.setBorder(new TitledBorder(null, "SQL", 0, 0, new Font("Tahoma", 0, 14)));
        this.sqlPanel.setAlignmentY(0.0f);
        this.sqlPanel.setAutoscrolls(true);
        this.fixedQueryPanel = new JPanel();
        this.fixedQueryPanel.setLayout(new BoxLayout(this.fixedQueryPanel, 0));
        this.fixedQueryLabel = new JLabel();
        this.fixedQueryLabel.setHorizontalAlignment(2);
        this.fixedQueryLabel.setText("Select SQL-example:");
        this.fixedQueryCombo = new JComboBox<String>(this.exampleQueryNames);
        this.fixedQueryCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.fixedQueryComboActionPerformed(actionEvent);
            }
        });
        this.fixedQueryPanel.add(this.fixedQueryLabel);
        this.fixedQueryPanel.add(Box.createRigidArea(new Dimension(3, 0)));
        this.fixedQueryPanel.add(this.fixedQueryCombo);
        this.queryPanel = new JPanel();
        this.queryPanel.setLayout(new BoxLayout(this.queryPanel, 0));
        this.queryPanel.setBorder(new TitledBorder("Query"));
        this.queryArea = new JTextArea();
        this.queryArea.setLineWrap(true);
        this.queryScrollPanel = this.createResultPanel(this.queryArea, null);
        this.queryArea.setBorder(new EtchedBorder());
        this.queryProcessButton = new JButton();
        this.queryProcessButton.setText("Process");
        this.queryProcessButton.setActionCommand("jButton1");
        this.queryProcessButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainWindow.this.queryProcessButtonMouseClicked(mouseEvent);
            }
        });
        this.nextPageButton = new JButton();
        this.nextPageButton.setText("next page");
        this.nextPageButton.setActionCommand("jButton1");
        this.nextPageButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainWindow.this.nextPage(mouseEvent);
            }
        });
        this.previousPageButton = new JButton();
        this.previousPageButton.setText("previous page");
        this.previousPageButton.setActionCommand("jButton1");
        this.previousPageButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainWindow.this.previousPage(mouseEvent);
            }
        });
        this.queryPanel.add(this.queryScrollPanel);
        this.queryPanel.add(this.queryProcessButton);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.sqlPanel.add((Component)this.fixedQueryPanel, gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.ipadx = 50;
        gridBagConstraints2.ipady = 20;
        gridBagConstraints2.weighty = 2.0;
        this.sqlPanel.add((Component)this.queryPanel, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 40;
        this.getContentPane().add((Component)this.sqlPanel, gridBagConstraints);
        this.resourcePanel = new JPanel();
        this.resourcePanel.setLayout(new GridLayout(2, 2));
        this.resourcePanelBorder = new TitledBorder(null, "Resources", 0, 0, new Font("Tahoma", 0, 14));
        this.resourcePanel.setBorder(this.resourcePanelBorder);
        this.documentsHTMLPanel = new JEditorPane();
        this.documentsHTMLPanel.setEditable(false);
        this.documentsHTMLPanel.setContentType("text/html");
        this.documentsPanel = this.createResultPanel(this.documentsHTMLPanel, "Documets");
        this.actorsHTMLPanel = new JEditorPane();
        this.actorsHTMLPanel.setEditable(false);
        this.actorsHTMLPanel.setContentType("text/html");
        this.actorsPanel = this.createResultPanel(this.actorsHTMLPanel, "Actors");
        this.channelsHTMLPanel = new JEditorPane();
        this.channelsHTMLPanel.setEditable(false);
        this.channelsHTMLPanel.setContentType("text/html");
        this.channelsPanel = this.createResultPanel(this.channelsHTMLPanel, "Channels");
        this.rolesHTMLPanel = new JEditorPane();
        this.rolesHTMLPanel.setEditable(false);
        this.rolesHTMLPanel.setContentType("text/html");
        this.rolesPanel = this.createResultPanel(this.rolesHTMLPanel, "Roles");
        this.resourcePanel.add(this.documentsPanel);
        this.resourcePanel.add(this.actorsPanel);
        this.resourcePanel.add(this.channelsPanel);
        this.resourcePanel.add(this.rolesPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.ipady = 350;
        this.getContentPane().add((Component)this.resourcePanel, gridBagConstraints);
        this.pageSelectorPanel = new JPanel();
        this.pageSelectorPanel.setLayout(new GridLayout(1, 2));
        this.pageSelectorPanel.add(this.previousPageButton);
        this.pageSelectorPanel.add(this.nextPageButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = 0;
        this.getContentPane().add((Component)this.pageSelectorPanel, gridBagConstraints);
        this.exportPanel = new JPanel();
        this.exportPanel.setLayout(new BoxLayout(this.exportPanel, 0));
        this.saveFileButton = new JButton();
        this.saveFileButton.setText("Save file");
        this.saveFileButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainWindow.this.saveFileButtonMouseClicked(mouseEvent);
            }
        });
        this.fileChooser = new JFileChooser();
        this.fileFormatPanel = new JPanel();
        this.fileFormatPanel.setLayout(new BoxLayout(this.fileFormatPanel, 1));
        this.fileFormatLabel = new JLabel();
        this.fileFormatLabel.setHorizontalAlignment(2);
        this.fileFormatLabel.setText("File Format:");
        this.fileFormatCombo = new JComboBox<String>(this.browser.getFileFormats());
        this.fileFormatCombo.setMaximumSize(new Dimension(327, 327));
        this.exportPanel.add(this.saveFileButton);
        this.exportPanel.add(Box.createRigidArea(new Dimension(50, 0)));
        this.exportPanel.add(this.fileFormatLabel);
        this.exportPanel.add(Box.createRigidArea(new Dimension(3, 0)));
        this.exportPanel.add(this.fileFormatCombo);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 0;
        this.getContentPane().add((Component)this.exportPanel, gridBagConstraints);
        this.pack();
    }

    private void getExampleQueries() {
        this.exampleQueriesFile = new File("config" + File.separator + "queries.xml");
        if (!this.exampleQueriesFile.exists()) {
            JOptionPane.showMessageDialog(this, "Could not find configuration file 'queries.xml'", "Configuration Error", 0);
        }
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        try {
            while (XMLTools.getNodeContent(this.builder, new FileInputStream(this.exampleQueriesFile), "examplequeries/query[" + (n + 1) + "]/menutext") != null && XMLTools.getNodeContent(this.builder, new FileInputStream(this.exampleQueriesFile), "examplequeries/query[" + (n + 1) + "]/sql") != null) {
                ++n;
            }
            this.exampleQueries = new String[n];
            this.exampleQueryNames = new String[n];
            for (int i = 0; i < n; ++i) {
                this.exampleQueries[i] = XMLTools.getNodeContent(this.builder, new FileInputStream(this.exampleQueriesFile), "examplequeries/query[" + (i + 1) + "]/sql");
                this.exampleQueryNames[i] = XMLTools.getNodeContent(this.builder, new FileInputStream(this.exampleQueriesFile), "examplequeries/query[" + (i + 1) + "]/menutext");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error reading configuration file 'queries.xml'", "Configuration Error", 0);
        }
    }

    private JScrollPane createResultPanel(JTextComponent jTextComponent, String string) {
        JScrollPane jScrollPane = new JScrollPane(jTextComponent);
        jScrollPane.setVerticalScrollBarPolicy(22);
        if (string != null) {
            jScrollPane.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jScrollPane;
    }

    private void queryProcessButtonMouseClicked(MouseEvent mouseEvent) {
        if (!this.updatingView) {
            this.updatingView = true;
            try {
                this.browser.executeSQL(this.queryArea.getText(), (String)this.graphSelectCombo.getSelectedItem());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), "SQL Error", 0);
                this.updatingView = false;
                return;
            }
            new Thread(this).start();
        }
    }

    private void saveFileButtonMouseClicked(MouseEvent mouseEvent) {
        if (!this.updatingView) {
            int n = 0;
            int n2 = this.fileChooser.showSaveDialog(this);
            if (n2 == 0) {
                if (this.fileChooser.getSelectedFile().exists()) {
                    n = JOptionPane.showConfirmDialog(this, "File exist. Do you wan't to overwrite?", "File exists!", 0);
                }
                if (n == 1) {
                    return;
                }
            }
            String string = this.fileChooser.getSelectedFile().getAbsolutePath();
            String string2 = (String)this.fileFormatCombo.getSelectedItem();
            this.browser.writeToFile(string, string2);
        }
    }

    private void fixedQueryComboActionPerformed(ActionEvent actionEvent) {
        int n = this.fixedQueryCombo.getSelectedIndex();
        this.queryArea.setText(this.exampleQueries[n]);
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        new MainWindow();
    }

    public void run() {
        this.documentsPages.clear();
        this.actorsPages.clear();
        this.channelsPages.clear();
        this.rolesPages.clear();
        this.documentsPanel.setBorder(new TitledBorder("Documents"));
        this.actorsPanel.setBorder(new TitledBorder("Actors"));
        this.channelsPanel.setBorder(new TitledBorder("Channels"));
        this.rolesPanel.setBorder(new TitledBorder("Roles"));
        this.resourcePanelBorder.setTitle("Fetching resources...");
        this.resourcePanel.repaint();
        this.documentsHTMLPanel.setText("no resources");
        this.actorsHTMLPanel.setText("no resources");
        this.channelsHTMLPanel.setText("no resources");
        this.rolesHTMLPanel.setText("no resources");
        Resource resource = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        try {
            resource = this.browser.nextResource();
            ++l;
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(this, sQLException.getMessage(), "Unsupported query", 0);
        }
        StringBuffer stringBuffer = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        StringBuffer stringBuffer2 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        StringBuffer stringBuffer3 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        StringBuffer stringBuffer4 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        this.pageCount = 1;
        this.currentPage = 0;
        while (resource != null) {
            if (resource.getType().equalsIgnoreCase("Document")) {
                stringBuffer.append("<tr><td>").append(resource.toHTML()).append("</td></tr>");
                ++l2;
            }
            if (resource.getType().equalsIgnoreCase("Actor")) {
                stringBuffer2.append("<tr><td>").append(resource.toHTML()).append("</td></tr>");
                ++l3;
            }
            if (resource.getType().equalsIgnoreCase("Channel")) {
                stringBuffer3.append("<tr><td>").append(resource.toHTML()).append("</td></tr>");
                ++l4;
            }
            if (resource.getType().equalsIgnoreCase("Role")) {
                stringBuffer4.append("<tr><td>").append(resource.toHTML()).append("</td></tr>");
                ++l5;
            }
            try {
                resource = this.browser.nextResource();
                ++l;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (l % 200L != 0L) continue;
            ++this.pageCount;
            stringBuffer.append("</table></body></html>");
            stringBuffer2.append("</table></body></html>");
            stringBuffer3.append("</table></body></html>");
            stringBuffer4.append("</table></body></html>");
            this.documentsPanel.setBorder(new TitledBorder("Documents (" + l2 + ")"));
            this.actorsPanel.setBorder(new TitledBorder("Actors (" + l3 + ")"));
            this.channelsPanel.setBorder(new TitledBorder("Channels (" + l4 + ")"));
            this.rolesPanel.setBorder(new TitledBorder("Roles (" + l5 + ")"));
            this.documentsPages.add(stringBuffer.toString());
            this.actorsPages.add(stringBuffer2.toString());
            this.channelsPages.add(stringBuffer3.toString());
            this.rolesPages.add(stringBuffer4.toString());
            stringBuffer = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
            stringBuffer2 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
            stringBuffer3 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
            stringBuffer4 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        }
        this.documentsPages.add(stringBuffer.toString());
        this.actorsPages.add(stringBuffer2.toString());
        this.channelsPages.add(stringBuffer3.toString());
        this.rolesPages.add(stringBuffer4.toString());
        stringBuffer = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        stringBuffer2 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        stringBuffer3 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        stringBuffer4 = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        this.resourcePanelBorder.setTitle("Forming resource views...");
        this.resourcePanel.repaint();
        this.documentsHTMLPanel.setText((String)this.documentsPages.get(0));
        this.actorsHTMLPanel.setText((String)this.actorsPages.get(0));
        this.channelsHTMLPanel.setText((String)this.channelsPages.get(0));
        this.rolesHTMLPanel.setText((String)this.rolesPages.get(0));
        this.resourcePanelBorder.setTitle("Resources page " + (this.currentPage + 1) + " of " + this.pageCount + " (" + this.PAGE_SIZE + " per page)");
        this.resourcePanel.repaint();
        this.updatingView = false;
    }

    private void nextPage(MouseEvent mouseEvent) {
        if (this.updatingView) {
            return;
        }
        int n = this.pageCount - 1;
        if (this.currentPage == n) {
            return;
        }
        ++this.currentPage;
        this.documentsHTMLPanel.setText((String)this.documentsPages.get(this.currentPage));
        this.actorsHTMLPanel.setText((String)this.actorsPages.get(this.currentPage));
        this.channelsHTMLPanel.setText((String)this.channelsPages.get(this.currentPage));
        this.rolesHTMLPanel.setText((String)this.rolesPages.get(this.currentPage));
        this.resourcePanelBorder.setTitle("Resources page " + (this.currentPage + 1) + " of " + this.pageCount);
        this.resourcePanel.repaint();
    }

    private void previousPage(MouseEvent mouseEvent) {
        if (this.updatingView) {
            return;
        }
        if (this.currentPage == 0) {
            return;
        }
        --this.currentPage;
        this.documentsHTMLPanel.setText((String)this.documentsPages.get(this.currentPage));
        this.actorsHTMLPanel.setText((String)this.actorsPages.get(this.currentPage));
        this.channelsHTMLPanel.setText((String)this.channelsPages.get(this.currentPage));
        this.rolesHTMLPanel.setText((String)this.rolesPages.get(this.currentPage));
        this.resourcePanelBorder.setTitle("Resources page " + (this.currentPage + 1) + " of " + this.pageCount);
        this.resourcePanel.repaint();
    }
}

