/*
 * Decompiled with CFR 0.152.
 */
package maito.consoleui;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import maito.LogListener;
import maito.datacollecting.DataCollector;
import maito.datacollecting.DataCollectorImpl;
import maito.datacollecting.DataSourceDescription;
import maito.integration.IntegrationException;
import maito.integration.Integrator;
import maito.integration.IntegratorImpl;

public class ConsoleUI
implements LogListener {
    private DataCollector collector = new DataCollectorImpl("data", "config");
    private Integrator integrator;
    private BufferedReader reader;

    public ConsoleUI() {
        this.collector.setLogListener(this);
        this.integrator = new IntegratorImpl();
        this.reader = new BufferedReader(new InputStreamReader(System.in));
    }

    public void logMessage(String string) {
        System.out.println(string);
    }

    public void start() {
        String string = null;
        System.out.println("MAITO 1.0 - under GPL\n");
        do {
            this.printMenu();
            string = this.getInput("enter choice (1 - 7) or hit enter to quit :");
            if (string.equals("1")) {
                this.listSources();
                continue;
            }
            if (string.equals("2")) {
                this.addSource();
                continue;
            }
            if (string.equals("3")) {
                this.removeSource();
                continue;
            }
            if (string.equals("4")) {
                this.updateSource();
                continue;
            }
            if (string.equals("5")) {
                this.listGraphs();
                continue;
            }
            if (string.equals("6")) {
                this.listGraphSources();
                continue;
            }
            if (!string.equals("7")) continue;
            this.integrateSource();
        } while (!string.equals(""));
    }

    private void printMenu() {
        System.out.println("\n* Data collecting *          * Integration *********\n\n1) list sources              5) list resource graphs\n2) add a new source          6) list graph sources\n3) remove a source           7) integrate a source\n4) update a source\n");
    }

    private boolean listSources() {
        System.out.println("All configured data sources :");
        DataSourceDescription[] dataSourceDescriptionArray = this.collector.getSources();
        int n = 0;
        if (dataSourceDescriptionArray != null) {
            n = dataSourceDescriptionArray.length;
        }
        if (n == 0) {
            System.out.println("no data sources");
        } else {
            for (int i = 0; i < n; ++i) {
                System.out.println(i + ": " + dataSourceDescriptionArray[i]);
            }
        }
        System.out.println();
        return n > 0;
    }

    private void addSource() {
        URL uRL;
        HashMap hashMap = this.collector.getSupportedTypes();
        if (hashMap == null || hashMap.size() == 0) {
            System.out.println("Error: No data source formats are supported");
            return;
        }
        System.out.println("Supported data source types :");
        System.out.println("---");
        HashSet hashSet = new HashSet(hashMap.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        System.out.println("---");
        String string = this.getInput("enter data source type :");
        if (!hashSet.contains(string)) {
            System.out.println("Error: Invalid type");
            return;
        }
        String[] stringArray = (String[])hashMap.get(string);
        if (stringArray == null) {
            System.out.println("Error: Unable to get formats for this source type");
            return;
        }
        System.out.println("Data formats for this source type :");
        System.out.println("---");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
        System.out.println("---");
        System.out.println("(NOTE: oai_citeseer should only be used for citeseer");
        System.out.println("extended database dump XML files, the standard oai-pmh");
        System.out.println("response is DCXML and won't be recognized with oai_citeseer!)\n");
        String string2 = this.getInput("enter data source format :");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            System.out.println("Error: Invalid data format");
            return;
        }
        String string3 = this.getInput("enter URL (http:// or file://) for the new data source :");
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Error: Invalid URL");
            return;
        }
        try {
            this.collector.addSource(null, string, uRL, string2);
            System.out.println("Data source successfully added. No data added yet - update the source to fetch and transform.");
        }
        catch (Exception exception) {
            System.out.println("Error: Could not add new source");
            System.out.println(exception.getMessage());
        }
    }

    private void removeSource() {
        if (!this.listSources()) {
            return;
        }
        String string = this.getInput("enter the number of source to remove, or * for all :");
        boolean bl = false;
        if (string.equals("*")) {
            bl = this.collector.removeSources(this.collector.getSources(), true);
        } else {
            try {
                int n = Integer.parseInt(string);
                DataSourceDescription[] dataSourceDescriptionArray = this.collector.getSources();
                DataSourceDescription[] dataSourceDescriptionArray2 = new DataSourceDescription[]{dataSourceDescriptionArray[n]};
                bl = this.collector.removeSources(dataSourceDescriptionArray2, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            System.out.println("sources removed successfully");
        } else {
            System.out.println("failed to remove one or more sources");
        }
    }

    private void updateSource() {
        if (!this.listSources()) {
            return;
        }
        String string = this.getInput("enter the number of source to update, or * for all :");
        DataSourceDescription[] dataSourceDescriptionArray = null;
        if (string.equals("*")) {
            dataSourceDescriptionArray = this.collector.getSources();
        } else {
            try {
                int n = Integer.parseInt(string);
                DataSourceDescription[] dataSourceDescriptionArray2 = this.collector.getSources();
                dataSourceDescriptionArray = new DataSourceDescription[]{dataSourceDescriptionArray2[n]};
            }
            catch (Exception exception) {
                dataSourceDescriptionArray = null;
            }
        }
        if (dataSourceDescriptionArray == null) {
            System.out.println("Update failed");
            return;
        }
        this.collector.updateSources(dataSourceDescriptionArray);
        while (this.collector.workInProgress()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean listGraphs() {
        System.out.println("Existing resource graphs :");
        List list = this.integrator.getGraphs();
        if (list == null || list.isEmpty()) {
            System.out.println("no graphs");
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            System.out.println((String)iterator.next());
        }
        System.out.println();
        return true;
    }

    private void listGraphSources() {
        if (!this.listGraphs()) {
            return;
        }
        String string = this.getInput("enter the name of the graph to show sources for :");
        List list = null;
        try {
            list = this.integrator.getSources(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("invalid graph");
            return;
        }
        if (list == null || list.isEmpty()) {
            System.out.println("no sources");
            return;
        }
        for (String[] stringArray : list) {
            System.out.println("- " + stringArray[0] + " (" + stringArray[1] + ")");
        }
        System.out.println();
    }

    private void integrateSource() {
        this.listGraphs();
        String string = this.getInput("enter the name of the destination graph (new or existing) :");
        if (!this.listSources()) {
            return;
        }
        String string2 = this.getInput("enter the number of source to integrate, or * for all :");
        DataSourceDescription[] dataSourceDescriptionArray = null;
        if (string2.equals("*")) {
            dataSourceDescriptionArray = this.collector.getSources();
        } else {
            try {
                int n = Integer.parseInt(string2);
                DataSourceDescription[] dataSourceDescriptionArray2 = this.collector.getSources();
                dataSourceDescriptionArray = new DataSourceDescription[]{dataSourceDescriptionArray2[n]};
            }
            catch (Exception exception) {
                dataSourceDescriptionArray = null;
            }
        }
        try {
            this.integrator.addGraph(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Invalid graph name");
            return;
        }
        try {
            this.integrator.integrate(dataSourceDescriptionArray, string);
        }
        catch (IntegrationException integrationException) {
            System.out.println("Integration failed: " + integrationException.getMessage());
            return;
        }
        while (this.integrator.workInProgress()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Done\n");
    }

    private String getInput(String string) {
        System.out.println(string);
        System.out.print(">");
        String string2 = "";
        try {
            string2 = this.reader.readLine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        new ConsoleUI().start();
    }
}

