/*
 * Decompiled with CFR 0.152.
 */
package maito.datacollecting;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import maito.LogListener;
import maito.datacollecting.DataCollector;
import maito.datacollecting.DataSource;
import maito.datacollecting.DataSourceDescription;
import maito.datacollecting.DataSourceException;
import maito.datacollecting.DataStorage;
import maito.datacollecting.RecordConstructor;
import maito.datacollecting.RecordParser;
import maito.datacollecting.Transformer;
import maito.util.DbTools;
import maito.util.Tools;
import maito.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataCollectorImpl
implements DataCollector {
    private Vector updaterThreads;
    private File[] sourceConfFiles;
    private File sourceTypesConfFile;
    private String dataDir;
    private Properties dbSettings;
    private LogListener logListener;
    private HashMap sources;
    private Vector errors;
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private Connection dbConnection;
    private final String CONF_FILE_IDENTIFIER = ".source";
    private final String SOURCEID_XPATH = "/source/id";
    private final String DATASOURCE_XPATH = "/source/datasource/class";
    private final String RECORDPARSER_XPATH = "/source/recordparser/class";
    private final String RECORDCONSTRUCTOR_XPATH = "/source/recordconstructor/class";
    private final String TRANSFORMER_XPATH = "/source/transformer/class";
    private final String ORIGINALLOCATION_XPATH = "/source/location/original";
    private final String RAWDATA_FILE_IDENTIFIER = ".rawdata";
    private final String DBCONFIG_FILENAME = "dbconfig.properties";
    private final String SOURCETYPESXML_FILENAME = "sourcetypes.xml";
    private final String DBNAME_KEY = "dbname_rawdata";
    private final String DATE_FORMAT = "yyyy-MM-dd";

    public DataCollectorImpl(String string, String string2) throws RuntimeException {
        this.dataDir = string;
        this.errors = new Vector();
        this.updaterThreads = new Vector();
        if (!new File(string2).isDirectory()) {
            throw new IllegalArgumentException("cannot access configuration files: " + string2 + " is not a directory");
        }
        this.dbSettings = Tools.loadProperties(string2 + File.separator + this.DBCONFIG_FILENAME);
        if (this.dbSettings == null) {
            throw new RuntimeException("failed to load database configuration");
        }
        try {
            this.initDatabase();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("database initialization failed: " + sQLException.getMessage());
        }
        try {
            this.dbConnection = DbTools.createDbConnection(this.dbSettings, this.dbSettings.getProperty(this.DBNAME_KEY));
            this.dbConnection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("cannot create database connection: " + sQLException.getMessage());
        }
        this.sourceTypesConfFile = new File(string2 + File.separator + this.SOURCETYPESXML_FILENAME);
        if (!this.sourceTypesConfFile.exists()) {
            throw new RuntimeException("configuration file " + this.SOURCETYPESXML_FILENAME + " was not found");
        }
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot prepare for xml parsing: " + exception.getMessage());
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(string + " should be a directory");
        }
        this.sourceConfFiles = this.getConfFiles(file);
        this.sources = this.createDataSources(this.sourceConfFiles);
        if (this.sources == null) {
            throw new RuntimeException("failed to initialize data sources");
        }
        Set set = this.sources.keySet();
        Iterator iterator = set.iterator();
        for (int i = 0; i < set.size(); ++i) {
            String string3 = (String)iterator.next();
            try {
                if (this.sourceExistsInDatabase(string3)) continue;
                this.addSourceToDatabase(string3, "unknown", string3);
                continue;
            }
            catch (SQLException sQLException) {
                throw new RuntimeException("database error: " + sQLException.getMessage());
            }
        }
    }

    public HashMap getSupportedTypes() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        String string = "/sourcetypes/rule/@transfertype";
        String[] stringArray = null;
        try {
            stringArray = XMLTools.getAllContents(this.builder, new FileInputStream(this.sourceTypesConfFile), string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (hashMap.containsKey(stringArray[i])) continue;
                String[] stringArray2 = XMLTools.getAllContents(this.builder, new FileInputStream(this.sourceTypesConfFile), "/sourcetypes/rule[@transfertype = '" + stringArray[i] + "']/@sourceformat");
                hashMap.put(stringArray[i], stringArray2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public boolean addSource(String string, String string2, URL uRL, String string3) throws RuntimeException {
        Object object;
        String string4 = this.getPath(uRL);
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            object = new File(string4);
            if (!((File)object).exists()) {
                throw new RuntimeException("the file " + string4 + " doesn't exist");
            }
            if (!((File)object).canRead()) {
                throw new RuntimeException("the file " + string4 + " is not readable");
            }
        }
        object = string4;
        try {
            if (this.sourceExistsInDatabase((String)object)) {
                throw new RuntimeException("source with location " + (String)object + " already exists");
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("database error: " + sQLException.getMessage());
        }
        try {
            this.addSourceToDatabase((String)object, string3, string4);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("unable to update database with data source " + (String)object + "\nreason: " + sQLException.getMessage());
        }
        File file = this.createSourceConfFile(string2, string4, string3);
        File[] fileArray = new File[]{file};
        HashMap hashMap = this.createDataSources(fileArray);
        this.sources.putAll(hashMap);
        return true;
    }

    public DataSourceDescription[] getSources() {
        Object object;
        Vector<DataSourceDescription> vector = new Vector<DataSourceDescription>();
        Set set = this.sources.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = "no successful update";
            String string2 = "not modified";
            long l = -1L;
            String string3 = "no format";
            boolean bl = false;
            try {
                Statement statement = this.dbConnection.createStatement();
                ResultSet resultSet = statement.executeQuery("select * from DataSource where id='" + string + "';");
                if (resultSet.next()) {
                    String string4 = resultSet.getString("updated");
                    if (string4 != null) {
                        object = string4;
                    }
                    if ((string4 = resultSet.getString("modified")) != null) {
                        string2 = string4;
                    }
                    l = resultSet.getLong("lineCount");
                    string4 = resultSet.getString("format");
                    if (string4 != null) {
                        string3 = string4;
                    }
                    resultSet.close();
                }
                resultSet = statement.executeQuery("select integratedTo from DataRecord where source='" + string + "' and integratedTo IS NOT NULL;");
                bl = resultSet.next();
                statement.close();
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                this.addError("database error: couldn't read properties for data source: " + string);
            }
            vector.add(new DataSourceDescription(string, (String)object, string2, l, string3, bl));
        }
        object = new DataSourceDescription[vector.size()];
        for (int i = 0; i < ((DataSourceDescription[])object).length; ++i) {
            object[i] = (DataSourceDescription)vector.get(i);
        }
        return object;
    }

    public void updateSources(DataSourceDescription[] dataSourceDescriptionArray) {
        this.errors.clear();
        Set set = this.sources.keySet();
        Iterator iterator = set.iterator();
        for (int i = 0; i < this.sources.size(); ++i) {
            String string = (String)iterator.next();
            for (int j = 0; j < dataSourceDescriptionArray.length; ++j) {
                if (!dataSourceDescriptionArray[j].getId().equals(string)) continue;
                DataSource dataSource = (DataSource)this.sources.get(string);
                UpdateThread updateThread = new UpdateThread(this, dataSource, string);
                this.updaterThreads.add(updateThread);
                updateThread.start();
                this.addLogMessage("updating source: " + string);
            }
        }
    }

    public boolean removeSources(DataSourceDescription[] dataSourceDescriptionArray, boolean bl) {
        for (int i = 0; i < dataSourceDescriptionArray.length; ++i) {
            Object object;
            File file;
            String string = dataSourceDescriptionArray[i].getId();
            System.out.println("removing source with id: " + string);
            if (this.sources.get(string) != null) {
                this.sources.remove(string);
            }
            if ((file = new File(this.getConfFileName(string))).exists()) {
                file.delete();
            }
            try {
                object = DbTools.createDbConnection(this.dbSettings, this.dbSettings.getProperty(this.DBNAME_KEY));
                object.setAutoCommit(true);
                Statement statement = object.createStatement();
                statement.execute("delete from Statement where source='" + string + "';");
                statement.execute("delete from DataRecord where source='" + string + "';");
                statement.execute("delete from DataSource where id='" + string + "';");
                statement.close();
                object.close();
            }
            catch (SQLException sQLException) {
                this.addError("couldn't remove data source from the database: " + sQLException.getMessage());
                return false;
            }
            if (bl && ((File)(object = new File(this.getRawdataFileName(string)))).exists()) {
                ((File)object).delete();
            }
            this.addLogMessage("removed data source: " + string);
        }
        return true;
    }

    public boolean workInProgress() {
        return this.updaterThreads.size() > 0;
    }

    public String[] getCurrentTasks() {
        String[] stringArray = new String[this.updaterThreads.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((UpdateThread)this.updaterThreads.get(i)).getTaskDescription();
        }
        return stringArray;
    }

    public String[] getErrors() {
        String[] stringArray = new String[this.errors.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.errors.get(i);
        }
        return stringArray;
    }

    public void setLogListener(LogListener logListener) {
        this.logListener = logListener;
    }

    private String getPath(URL uRL) {
        String string = null;
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            string = uRL.getPath();
            if (string.equals("")) {
                string = uRL.getHost();
            }
        } else {
            string = uRL.toString();
        }
        return string;
    }

    private void addSourceToDatabase(String string, String string2, String string3) throws SQLException {
        String string4 = this.validateSourceAttributes(string, string2, string3);
        if (string4 != null) {
            throw new SQLException(string4);
        }
        Statement statement = this.dbConnection.createStatement();
        String string5 = "insert into DataSource values ('" + string + "'," + "'" + string2 + "'," + "'" + string3 + "'," + "0," + "NULL," + "NULL" + ");";
        statement.execute(string5);
        statement.close();
    }

    private String validateSourceAttributes(String string, String string2, String string3) {
        String string4 = null;
        try {
            Statement statement = this.dbConnection.createStatement();
            ResultSet resultSet = statement.executeQuery("select * from DataSource;");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = 0;
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (resultSetMetaData.getColumnName(i).equals("id")) {
                    n = resultSetMetaData.getColumnDisplaySize(i);
                    if (string.length() > n) {
                        string4 = "data source's URL is too long";
                        break;
                    }
                }
                if (!resultSetMetaData.getColumnName(i).equals("location")) continue;
                n = resultSetMetaData.getColumnDisplaySize(i);
                if (string3.length() <= n) continue;
                string4 = "data source's URL is too long";
                break;
            }
            statement.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            string4 = "unable to read database metadata";
            sQLException.printStackTrace();
        }
        return string4;
    }

    private boolean sourceExistsInDatabase(String string) throws SQLException {
        Statement statement = this.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("select id from DataSource where id='" + string + "';");
        boolean bl = resultSet.next();
        statement.close();
        resultSet.close();
        return bl;
    }

    private File createSourceConfFile(String string, String string2, String string3) {
        Object object;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        try {
            object = "/sourcetypes/rule[@sourceformat=\"" + string3 + "\" and @transfertype=\"" + string + "\"]";
            string4 = XMLTools.getNodeContent(this.builder, new FileInputStream(this.sourceTypesConfFile), (String)object + "/datasource");
            string5 = XMLTools.getNodeContent(this.builder, new FileInputStream(this.sourceTypesConfFile), (String)object + "/recordparser");
            string6 = XMLTools.getNodeContent(this.builder, new FileInputStream(this.sourceTypesConfFile), (String)object + "/recordconstructor");
            string7 = XMLTools.getNodeContent(this.builder, new FileInputStream(this.sourceTypesConfFile), (String)object + "/transformer");
        }
        catch (Exception exception) {
            this.addError("couldn't create data source configuration file for: " + string2);
            return null;
        }
        object = this.builder.newDocument();
        Element element = object.createElement("source");
        object.appendChild(element);
        element.appendChild(object.createElement("id")).appendChild(object.createTextNode(string2.toString()));
        element.appendChild(object.createElement("location")).appendChild(object.createElement("original")).appendChild(object.createTextNode(string2));
        element.appendChild(object.createElement("datasource")).appendChild(object.createElement("class")).appendChild(object.createTextNode(string4));
        element.appendChild(object.createElement("recordparser")).appendChild(object.createElement("class")).appendChild(object.createTextNode(string5));
        element.appendChild(object.createElement("recordconstructor")).appendChild(object.createElement("class")).appendChild(object.createTextNode(string6));
        element.appendChild(object.createElement("transformer")).appendChild(object.createElement("class")).appendChild(object.createTextNode(string7));
        String string8 = this.getConfFileName(string2.toString());
        File file = XMLTools.writeDocumentToFile((Document)object, string8);
        return file;
    }

    private String getConfFileName(String string) {
        return this.dataDir + File.separator + string.replaceAll("[^:]*://", "").replaceAll("/", "_").replaceAll("\\\\", "_").replaceAll(":", "_") + this.CONF_FILE_IDENTIFIER;
    }

    private String getRawdataFileName(String string) {
        return this.dataDir + File.separator + string.replaceAll("[^:]*://", "").replaceAll("/", "_") + this.RAWDATA_FILE_IDENTIFIER;
    }

    private File[] getConfFiles(File file) {
        File[] fileArray = file.listFiles();
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(this.CONF_FILE_IDENTIFIER)) continue;
            vector.add(fileArray[i]);
        }
        File[] fileArray2 = new File[vector.size()];
        fileArray2 = vector.toArray(fileArray2);
        return fileArray2;
    }

    private HashMap createDataSources(File[] fileArray) {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                String string = XMLTools.getNodeContent(this.builder, new FileInputStream(fileArray[i]), this.SOURCEID_XPATH);
                String string2 = XMLTools.getNodeContent(this.builder, new FileInputStream(fileArray[i]), this.DATASOURCE_XPATH);
                String string3 = XMLTools.getNodeContent(this.builder, new FileInputStream(fileArray[i]), this.RECORDPARSER_XPATH);
                String string4 = XMLTools.getNodeContent(this.builder, new FileInputStream(fileArray[i]), this.RECORDCONSTRUCTOR_XPATH);
                String string5 = XMLTools.getNodeContent(this.builder, new FileInputStream(fileArray[i]), this.TRANSFORMER_XPATH);
                String string6 = XMLTools.getNodeContent(this.builder, new FileInputStream(fileArray[i]), this.ORIGINALLOCATION_XPATH);
                Class[] classArray = null;
                Object[] objectArray = null;
                Transformer transformer = null;
                transformer = (Transformer)Class.forName(string5).newInstance();
                File file = new File(this.getRawdataFileName(string));
                DataStorage dataStorage = new DataStorage(string, this.dbConnection, file, transformer);
                RecordConstructor recordConstructor = null;
                recordConstructor = (RecordConstructor)Class.forName(string4).newInstance();
                RecordParser recordParser = null;
                classArray = new Class[]{Class.forName("maito.datacollecting.RecordConstructor"), Class.forName("maito.datacollecting.DataStorage")};
                objectArray = new Object[]{recordConstructor, dataStorage};
                recordParser = (RecordParser)Class.forName(string3).getConstructor(classArray).newInstance(objectArray);
                classArray = new Class[]{Class.forName("java.util.Properties"), Class.forName("maito.datacollecting.RecordParser")};
                objectArray = new Object[2];
                Properties properties = new Properties();
                properties.put("location", string6);
                String string7 = this.getUpdated(string);
                if (string7 != null) {
                    properties.put("updated", string7);
                }
                objectArray[0] = properties;
                objectArray[1] = recordParser;
                Object obj = Class.forName(string2).getConstructor(classArray).newInstance(objectArray);
                hashMap.put(string, obj);
                continue;
            }
            catch (Exception exception) {
                this.addError("unable to init data sources: " + exception.getMessage());
                return null;
            }
        }
        return hashMap;
    }

    private String getUpdated(String string) throws SQLException {
        String string2 = null;
        Statement statement = this.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("select updated from DataSource where id = '" + string + "';");
        if (resultSet.next()) {
            string2 = resultSet.getString("updated");
        }
        statement.close();
        if (resultSet != null) {
            resultSet.close();
        }
        return string2;
    }

    private synchronized void addError(String string) {
        this.errors.add(string);
        if (this.logListener != null) {
            this.logListener.logMessage(string);
        }
    }

    private synchronized void addLogMessage(String string) {
        if (this.logListener != null) {
            this.logListener.logMessage(string);
        }
    }

    private void initDatabase() throws SQLException {
        this.dbConnection = DbTools.createDbConnection(this.dbSettings);
        String string = this.dbSettings.getProperty(this.DBNAME_KEY);
        Statement statement = this.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SHOW DATABASES LIKE '" + string + "'");
        if (!resultSet.next()) {
            this.addLogMessage("initializing database " + string);
            String string2 = Tools.readFile(Tools.PATH_RAWDATA_SQL);
            if (string2 == null) {
                throw new SQLException("Error loading sql script file: " + Tools.PATH_RAWDATA_SQL);
            }
            statement.executeUpdate("CREATE DATABASE IF NOT EXISTS " + string + " CHARACTER SET utf8");
            statement.executeUpdate("USE " + string);
            int n = 0;
            int n2 = string2.indexOf(";", n);
            while (n2 != -1) {
                String string3 = string2.substring(n, n2);
                statement.execute(string3);
                n = n2 + 1;
                n2 = string2.indexOf(";", n);
            }
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        this.dbConnection.close();
    }

    private synchronized void updateFinished(String string, UpdateThread updateThread, boolean bl) {
        if (bl) {
            String string2 = new SimpleDateFormat(this.DATE_FORMAT).format(new Date());
            String string3 = "update DataSource set updated = '" + string2 + "' where id='" + string + "';";
            try {
                Connection connection = DbTools.createDbConnection(this.dbSettings, this.dbSettings.getProperty(this.DBNAME_KEY));
                Statement statement = connection.createStatement();
                statement.execute(string3);
                statement.close();
                connection.close();
            }
            catch (SQLException sQLException) {
                this.addError("couldn't set update date for data source: " + string);
                sQLException.printStackTrace();
            }
        }
        this.addLogMessage("update finished for data source: " + string);
        this.updaterThreads.remove(updateThread);
    }

    class UpdateThread
    extends Thread {
        private DataCollectorImpl collector;
        private DataSource source;
        private String sourceId;

        public UpdateThread(DataCollectorImpl dataCollectorImpl2, DataSource dataSource, String string) {
            this.collector = dataCollectorImpl2;
            this.source = dataSource;
            this.sourceId = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = true;
            try {
                this.source.update();
            }
            catch (DataSourceException dataSourceException) {
                this.collector.addError("error while updating source " + this.sourceId + ": " + dataSourceException.getMessage());
                bl = false;
            }
            finally {
                this.collector.updateFinished(this.sourceId, this, bl);
            }
        }

        public String getTaskDescription() {
            return "updating data source " + this.sourceId;
        }
    }
}

