/*
 * Decompiled with CFR 0.152.
 */
package maito.datacollecting.dcxml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import maito.datacollecting.Record;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class DCXMLRecordConstructWorker
implements ErrorHandler {
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private Document doc;
    private Record rec;
    private int format;
    private static final String[] DCFIELDS = new String[]{"dc:title", "dc:creator", "dc:subject", "dc:description", "dc:publisher", "dc:contributor", "dc:date", "dc:type", "dc:format", "dc:identifier", "dc:language", "dc:relation", "dc:bibliographicCitation", "dc:issued", "dc:references", "dc:isReferencedBy", "dc:rightsHolder"};
    private static final String[] CITESEERFIELDS = new String[]{"oai_citeseer:author/@name", "oai_citeseer:author/affiliation", "oai_citeseer:relation[@type='References']/oai_citeseer:uri", "oai_citeseer:relation[@type='Is Referenced By']/oai_citeseer:uri"};
    private static final String[] CITESEERNAMES = new String[]{"oai_citeseer:authorName", "oai_citeseer:authorAffiliation", "oai_citeseer:relationReferences", "oai_citeseer:relationIsReferencedBy"};
    public static final int RECORD_DCXML = 0;
    public static final int RECORD_CITESEER = 1;
    private static final String[] PATHS = new String[]{"/record/metadata/oai_dc:dc/", "/record/metadata/oai_citeseer:oai_citeseer/"};

    protected Record constructRecord(String string, int n) throws IllegalArgumentException {
        int n2;
        String[] stringArray;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal record format");
        }
        this.format = n;
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
        try {
            this.builder = this.factory.newDocumentBuilder();
            this.builder.setErrorHandler(this);
            stringArray = new ByteArrayInputStream(string.getBytes());
            this.doc = this.builder.parse((InputStream)stringArray);
        }
        catch (Exception exception) {
            System.out.println("Invalid record received. Skipping and continuing.");
            return null;
        }
        stringArray = this.getNodeContent("/record/header/identifier");
        if (stringArray.length > 0) {
            stringArray[0] = stringArray[0].trim();
            this.rec = new Record(stringArray[0]);
            if (this.format == 1) {
                this.rec.setField("oai_citeseer:identifier", stringArray[0]);
            }
        } else {
            this.rec = new Record("");
        }
        for (n2 = 0; n2 < DCFIELDS.length; ++n2) {
            this.addToRecord(DCFIELDS[n2], DCFIELDS[n2]);
        }
        if (this.format == 1) {
            for (n2 = 0; n2 < CITESEERFIELDS.length; ++n2) {
                this.addToRecord(CITESEERFIELDS[n2], CITESEERNAMES[n2]);
            }
        }
        return this.rec;
    }

    private void addToRecord(String string, String string2) {
        String[] stringArray = this.getNodeContent(PATHS[this.format] + string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this.rec.setField(string2, stringArray[i].trim());
            }
        }
    }

    private String[] getNodeContent(String string) {
        String[] stringArray = null;
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
            xPath.setNamespaceContext(namespaceContextImpl);
            NodeList nodeList = (NodeList)xPath.evaluate(string, this.doc, XPathConstants.NODESET);
            stringArray = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node == null) continue;
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    if (nodeList2.item(j).getNodeType() != 3) continue;
                    stringArray[i] = nodeList2.item(j).getNodeValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public void error(SAXParseException sAXParseException) {
    }

    public void fatalError(SAXParseException sAXParseException) {
    }

    public void warning(SAXParseException sAXParseException) {
    }

    protected boolean testNamespaceImpl() {
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        boolean bl = namespaceContextImpl.getNamespaceURI("dc").equals("http://purl.org/dc/elements/1.1/");
        boolean bl2 = namespaceContextImpl.getPrefix("http://copper.ist.psu.edu/oai/oai_citeseer/").equals("oai_citeseer");
        String string = namespaceContextImpl.getPrefixes("http://www.openarchives.org/OAI/2.0/oai_dc/").next();
        boolean bl3 = string.equals("oai_dc");
        boolean bl4 = namespaceContextImpl.getNamespaceURI("foo").equals("");
        boolean bl5 = namespaceContextImpl.getPrefix("http://foo.bar/").equals("");
        boolean bl6 = !namespaceContextImpl.getPrefixes("http://foo.bar").hasNext();
        boolean bl7 = bl & bl2 & bl3 & bl4 & bl5 & bl6;
        return bl7;
    }

    private class NamespaceContextImpl
    implements NamespaceContext {
        public String[] uris = new String[]{"http://www.openarchives.org/OAI/2.0/oai_dc/", "http://purl.org/dc/elements/1.1/", "http://copper.ist.psu.edu/oai/oai_citeseer/"};
        public String[] prefixes = new String[]{"oai_dc", "dc", "oai_citeseer"};

        private NamespaceContextImpl() {
        }

        public String getNamespaceURI(String string) {
            for (int i = 0; i < this.prefixes.length; ++i) {
                if (!string.equals(this.prefixes[i])) continue;
                return this.uris[i];
            }
            return "";
        }

        public String getPrefix(String string) {
            for (int i = 0; i < this.uris.length; ++i) {
                if (!string.equals(this.uris[i])) continue;
                return this.prefixes[i];
            }
            return "";
        }

        public Iterator getPrefixes(String string) {
            for (int i = 0; i < this.uris.length; ++i) {
                if (!string.equals(this.uris[i])) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this.prefixes[i]);
                return arrayList.iterator();
            }
            return new ArrayList().iterator();
        }
    }
}

