/*
 * Decompiled with CFR 0.152.
 */
package maito.datacollecting.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Properties;
import maito.datacollecting.DataSource;
import maito.datacollecting.DataSourceException;
import maito.datacollecting.RecordParser;

public class FileDataSource
implements DataSource {
    private BufferedReader fread;
    private RecordParser recordParser;
    private String baseURL;
    private char[] cbuf;
    private String thisLine;
    private final int BLOCK_SIZE = 1024;

    public FileDataSource(Properties properties, RecordParser recordParser) throws DataSourceException {
        if (properties == null) {
            throw new DataSourceException("maito.datacollecting.file.FileDataSource: null parameter set");
        }
        this.baseURL = properties.getProperty("location");
        if (this.baseURL == null) {
            throw new DataSourceException("maito.datacollecting.file.FileDataSource: parameter location missing");
        }
        if (recordParser == null) {
            throw new DataSourceException("maito.datacollecting.file.FileDataSource: recordParser not defined");
        }
        this.recordParser = recordParser;
    }

    public void update() throws DataSourceException {
        this.updateInBlocks();
    }

    private void updateInLines() throws DataSourceException {
        try {
            URI uRI = new URI(this.baseURL);
            File file = new File(uRI);
            this.fread = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        }
        catch (Exception exception) {
            throw new DataSourceException("maito.datacollecting.file.FileDataSource: error opening file: " + this.baseURL);
        }
        try {
            while ((this.thisLine = this.fread.readLine()) != null) {
                this.recordParser.putData(this.thisLine);
            }
            this.recordParser.putData(null);
        }
        catch (IOException iOException) {
            throw new DataSourceException("maito.datacollecting.file.FileDataSource: error reading file " + this.baseURL);
        }
    }

    private void updateInBlocks() throws DataSourceException {
        this.cbuf = new char[1024];
        try {
            if (this.baseURL.startsWith("file://")) {
                this.baseURL = this.baseURL.substring(7, this.baseURL.length());
            }
            File file = new File(this.baseURL);
            this.fread = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        }
        catch (Exception exception) {
            throw new DataSourceException("maito.datacollecting.file.FileDataSource: error opening file: " + this.baseURL + ", " + exception.getMessage());
        }
        try {
            while (this.fread.read(this.cbuf, 0, 1024) != -1) {
                this.recordParser.putData(new String(this.cbuf));
            }
        }
        catch (IOException iOException) {
            throw new DataSourceException("maito.datacollecting.file.FileDataSource: error reading file " + this.baseURL);
        }
    }
}

