/*
 * Decompiled with CFR 0.152.
 */
package maito.datacollecting.oaipmh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import maito.datacollecting.oaipmh.ListRecordsContentHandler;
import maito.datacollecting.oaipmh.OAIPMHException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ListRecords {
    private URL url;
    private String baseURL;
    private ListRecordsContentHandler contentHandler;
    private XMLReader xmlReader;
    private InputStream in;
    private String resumptionToken;
    private StringBuffer buffer;
    private final int CONNECTION_TIMEOUT = 5000;

    protected ListRecords(String string, String string2, String string3) throws OAIPMHException {
        if (string == null) {
            throw new OAIPMHException("parameter baseURL is null");
        }
        if (string2 == null) {
            throw new OAIPMHException("parameter metadataPrefix is null");
        }
        this.contentHandler = new ListRecordsContentHandler();
        try {
            this.xmlReader = XMLReaderFactory.createXMLReader();
            this.xmlReader.setContentHandler(this.contentHandler);
            this.xmlReader.setErrorHandler(this.contentHandler);
        }
        catch (SAXException sAXException) {
            throw new OAIPMHException("couldn't prepare for xml parsing");
        }
        this.baseURL = string;
        this.buffer = new StringBuffer();
        this.resumptionToken = null;
        try {
            String string4 = string + "?verb=ListRecords&metadataPrefix=" + string2;
            if (string3 != null) {
                string4 = string4 + "&from=" + string3;
            }
            this.url = new URL(string4);
        }
        catch (Exception exception) {
            throw new OAIPMHException(exception.getMessage());
        }
        this.readFromRepository();
    }

    protected String nextPart(int n) throws OAIPMHException {
        String string = "";
        if (n <= 0) {
            return null;
        }
        if (this.buffer.length() == 0 && this.resumptionToken == null) {
            return null;
        }
        if (n > this.buffer.length()) {
            string = this.buffer.toString();
            n -= this.buffer.length();
            this.buffer = new StringBuffer();
            while (this.resumptionToken != null && n > 0) {
                if (this.buffer.length() == 0) {
                    this.readFromRepository();
                }
                if (n <= this.buffer.length()) {
                    string = string + this.buffer.substring(0, n);
                    this.buffer.delete(0, n);
                    n = 0;
                    continue;
                }
                string = string + this.buffer.toString();
                n -= this.buffer.length();
                this.buffer = new StringBuffer();
            }
        } else {
            string = string + this.buffer.substring(0, n);
            this.buffer.delete(0, n);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readFromRepository() throws OAIPMHException {
        boolean bl = false;
        try {
            Object object;
            while (!bl) {
                this.fillBuffer();
                object = new InputSource(new StringReader(new String(this.buffer)));
                try {
                    this.xmlReader.parse((InputSource)object);
                    bl = true;
                }
                catch (SAXException sAXException) {
                    this.resumptionToken = this.searchResumptionTokenFromCorruptXML();
                    if (this.resumptionToken == null) throw new OAIPMHException("OAI-PMH harvesting stopped. The server's response was corrupted.\n(details: " + sAXException.getMessage() + " )");
                    System.out.println(this.baseURL + " sent an invalid xml response. Some of the data was ignored.\n" + "(details: " + sAXException.getMessage() + ")");
                    try {
                        this.url = new URL(this.baseURL + "?verb=ListRecords&resumptionToken=" + this.resumptionToken);
                    }
                    catch (Exception exception) {
                        throw new OAIPMHException(exception);
                    }
                }
            }
            object = this.contentHandler.getError();
            if (object != null) {
                String string = "An error was found in the OAI-PMH response: " + (String)object;
                throw new OAIPMHException(string);
            }
            this.handleResumptionToken();
            this.extractRecords();
            return;
        }
        catch (IOException iOException) {
            throw new OAIPMHException(iOException.getMessage());
        }
    }

    private void fillBuffer() throws IOException {
        this.buffer = new StringBuffer();
        URLConnection uRLConnection = this.url.openConnection();
        uRLConnection.setConnectTimeout(this.CONNECTION_TIMEOUT);
        this.in = uRLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
        String string = bufferedReader.readLine();
        while (string != null) {
            this.buffer.append(string + "\n");
            string = bufferedReader.readLine();
        }
        this.in.close();
    }

    private void handleResumptionToken() throws OAIPMHException {
        this.resumptionToken = this.contentHandler.getResumptionToken();
        if (this.resumptionToken != null) {
            try {
                this.url = new URL(this.baseURL + "?verb=ListRecords&resumptionToken=" + this.resumptionToken);
            }
            catch (Exception exception) {
                throw new OAIPMHException(exception);
            }
        }
    }

    private String searchResumptionTokenFromCorruptXML() {
        String string = null;
        String string2 = "<resumptionToken[^>]*>";
        String string3 = "</resumptionToken>";
        Pattern pattern = Pattern.compile(string2);
        Pattern pattern2 = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(this.buffer);
        Matcher matcher2 = pattern2.matcher(this.buffer);
        if (matcher.find() && matcher2.find()) {
            if (matcher.end() > matcher2.start()) {
                return null;
            }
            string = this.buffer.substring(matcher.end(), matcher2.start());
        }
        return string;
    }

    private void extractRecords() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "<record>";
        String string2 = "</record>";
        int n = this.buffer.indexOf(string);
        int n2 = this.buffer.indexOf(string2);
        while (n >= 0 && n2 >= 0) {
            stringBuffer.append(this.buffer.substring(n, n2 + string2.length()));
            this.buffer.delete(n, n2 + string2.length());
            n = this.buffer.indexOf(string);
            n2 = this.buffer.indexOf(string2);
        }
        this.buffer = stringBuffer;
    }
}

